<?php
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

class ClubmanagementControllerContacts extends ClubmanagementController
{
	/**
	 * constructor (registers additional tasks to methods)
	 * @return void
	 */
	function __construct()
	{
		parent::__construct();

		JRequest::setVar( 'view', 'contacts' );
		// Register Extra tasks
		$this->registerTask( 'add'  , 	'edit' );
	}

	/**
	 * display the edit form
	 * @return void
	 */
	function edit()
	{
		JRequest::setVar( 'view', 'contacts' );
		JRequest::setVar('hidemainmenu', 1);

		parent::display();
	}

	/**
	 * save a record (and redirect to main page)
	 * @return void
	 */
	function save()
	{
		$model = $this->getModel('Contacts');

		if ($model->store($post)) {
			$msg = JText::_( 'Banking Saved!' );
		} else {
			$msg = JText::_( 'Error Saving Clubmanagement' );
		}

		// Check the table in so it can be edited.... we are done with it anyway
		$link = 'index.php?option=com_clubmanagement&view=people';
#print_r($post);
		$this->setRedirect($link, $msg);
	}

	/**
	 * remove record(s)
	 * @return void
	 */
	function remove()
	{
		$model = $this->getModel('Contacts');
		if(!$model->delete()) {
			$msg = JText::_( 'Error: One or more Clubmanagements could not be Deleted' );
		} else {
			$msg = JText::_( 'Clubmanagement(s) Deleted' );
		}

		$this->setRedirect( 'index.php?option=com_clubmanagement&view=people', $msg );
	}

	/**
	 * cancel editing a record
	 * @return void
	 */
	function cancel()
	{
		$msg = JText::_( 'Operation Cancelled' );
		$this->setRedirect( 'index.php?option=com_clubmanagement&view=people', $msg );
	}
}
?>
