<?php
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

class ClubmanagementControllerPeople extends ClubmanagementController
{
	/**
	 * constructor (registers additional tasks to methods)
	 * @return void
	 */
	function __construct()
	{
		parent::__construct();
		// Register Extra tasks
		$this->registerTask( 'add'  , 	'edit' );
		$view  = &$this->getView('people', 'html');

		$model1 = $this->getModel ('people');
		$view->setModel($model1, TRUE);
		$model2 = $this->getModel('members');
		$view->setModel($model2);
		$model3 = $this->getModel('banking');
		$view->setModel($model3);
		$model4 = $this->getModel('administration');
		$view->setModel($model4);
		$model5 = $this->getModel('contacts');
		$view->setModel($model5);
		$model6 = $this->getModel('positions');
		$view->setModel($model6);

		$this->registerTask( 'apply', 'save' );
	}
	/**
	 * display the edit form
	 * @return void
	 */
	function edit()
	{
		JRequest::setVar( 'view', 'people' );
		JRequest::setVar( 'layout', 'form'  );
		JRequest::setVar('hidemainmenu', 1);

		parent::display();
	}

	/**
	 * save a record (and redirect to main page)
	 * @return void
	 */
	function save()
	{
		$model = $this->getModel('People');

		if ($model->store($post)) {
			$msg = JText::_( 'People Saved!' );
		} else {
			$msg = JText::_( 'Error Saving Clubmanagement' );
		}


		switch (JRequest::getCmd( 'task' ))
		{
			case 'apply':
				$cid	= intval(JRequest::getVar('people_id'));
				$link = 'index.php?option=com_clubmanagement&view=people&task=edit&cid[]='. $cid ;
				$this->setRedirect($link, $msg);
			break;
			default:
				$link = 'index.php?option=com_clubmanagement&view=people';
				$this->setRedirect($link, $msg);
			break;
		}
		// Check the table in so it can be edited.... we are done with it anyway
		$this->setRedirect($link, $msg);
	}

	/**
	 * remove record(s)
	 * @return void
	 */
	function remove()
	{
		$model = $this->getModel('people');
		if(!$model->delete()) {
			$msg = JText::_( 'Error: One or more Clubmanagements could not be Deleted' );
		} else {
			$msg = JText::_( 'Clubmanagement(s) Deleted' );
		}

		$this->setRedirect( 'index.php?option=com_clubmanagement&view=people', $msg );
	}

	/**
	 * cancel editing a record
	 * @return void
	 */
	function cancel()
	{
		$msg = JText::_( 'Operation Cancelled' );
		$this->setRedirect( 'index.php?option=com_clubmanagement&view=people', $msg );
	}
}
?>
