<?php
/**
*	@author MDY
*	@package Joomla.Component.Clubmanagement
*	@version 1.0
**/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

jimport( 'joomla.application.component.model' );

class ClubmanagementModelMembers extends JModel
{
	/**
	 * Autos data array
	 *
	 * @var array
	 */
	private $_data;
	private $_id;



	function __construct()
	{
#		global $mainframe;
		$mainframe = JFactory::getApplication();
		parent::__construct();

		$tmp = JRequest::getVar('cid',  NULL);
		$this->setId((int)$tmp[0]);

		// Get pagination request variables
		$limit = $mainframe->getUserStateFromRequest('global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 10);
		$limitstart = $mainframe->getUserStateFromRequest($option.'.limitstart', 'limitstart', 0, 0);

		// In case limit has been changed, adjust it
		$limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);

		$this->setState('limit', $limit);
		$this->setState('limitstart', $limitstart);
		$this->getLists();

	}

	function setId($id)
	{
		// Set id and wipe data
		$this->_id		= $id;
		$this->_data	= null;
	}

	/**
	 * @return array Array of objects containing the data from the database
	 */
	function getPersonalData($pid=NULL)
	{
		$db		=& $this->getDBO();
		// Lets load the data if it doesn't already exist

		/* load filters */
		$where = array();
		$date = strtotime($this->_list["filter_byDate"]);
		if (!empty($this->_list['filter_byDate']) && $date!==FALSE) {
			$date = date("Y-m-d", $date);
			$where[] = "(member_from <= '".$date."' OR member_from IS NULL) AND (member_until>='".$date."' OR member_until IS NULL)";
		} 	
		if (!empty($this->_list['filter_section'])) {
			$where[] = "s.id = '".$this->_list['filter_section']."'";
		} 	

		if ($this->_list['filter_state_sex']==='f' || $this->_list['filter_state_sex']==='m') {
			$where[] = "p.sex = '".$this->_list['filter_state_sex']."'";
		}
		if (is_array($pid)) {
			JArrayHelper::toInteger($pid);
			$where[] = "p.people_id IN (".implode(",", $pid).")";
		} else if (is_null($pid)) {
		} else {
			$where[] = "p.people_id = '".intval($pid)."'";
		}
		$where = (count($where) ? ' WHERE '.implode(' AND ', $where) : '');
		/* end load filters */

		/* ordering */
		#echo $this->_list['filter_order'];
		#print_r($this->_list);
		switch($this->_list['order']) {
			default:
			case "surname":
				$order = "p.surname";
			break;
			case "name":
				$order = "p.name";
			break;
			case "membertimes":
				$order = "m.member_from";
			break;
		}
		$orderby 	= ' ORDER BY '. $order .' '. $this->_list['order_Dir'];

		if (is_null($pid)) {
			if (empty( $this->_data ))
			{
				$query = "
					SELECT 
						p.people_id, 
						m.section_id, 
						CONCAT(
							'\n\<\?xml version=\"1.0\" encoding=\"utf-8\"\?\>\n\<', 
							'membertimes\>\n',
							GROUP_CONCAT(CONCAT(' <','item section=\'', IF(s.title IS NULL,' ',s.title), '\' from=\'', IF(m.member_from IS NULL,' ',m.member_from), '\' until=\'', IF(m.member_until IS NULL,' ',m.member_until), '\'\/>') SEPARATOR ' '),
							'\n\<\/membertimes\>'	
						) as membertimes,
						p.sex, 
						p.name, 
						p.surname,
						s.id,
						s.title AS section,
						s.image AS sectionImage,
						'|' AS concatenator
					FROM #__clubmanagement_membership AS m
					LEFT JOIN #__clubmanagement_people AS p ON m.people_id = p.people_id
					LEFT JOIN #__categories AS s ON m.section_id = s.id
					".$where."
					GROUP BY p.people_id
					".$orderby."
					";

				$db->setQuery($query);
				$this->setState('total', count($db->loadObjectlist()));

#echo "<pre>";
#print_r($db->loadObjectlist());
#echo $this->getState('limit');
#echo "</pre>";
				$db->setQuery($query, $this->getState('limitstart'), $this->getState('limit'));
				$this->_data = $db->loadObjectlist();
			}
		} else {
			$query = "
				SELECT 
					p.people_id, 
					m.member_from, 
					m.member_until, 
					m.section_id, 
					m.membership_id,
					m.passport AS member_passport,
					p.sex, 
					p.name, 
					p.surname,
					s.id,
					s.title AS section,
					s.image AS sectionImage
				FROM #__clubmanagement_membership AS m
				LEFT JOIN #__clubmanagement_people AS p ON m.people_id = p.people_id
				LEFT JOIN #__categories AS s ON m.section_id = s.id
				".$where."
				".$orderby."
				";
			$db->setQuery($query, $this->getState('limitstart'), $this->getState('limit'));
			$this->_data = $db->loadObjectlist();
		}
echo $db->getQuery();
#print_r($this->_data);

		// Create the pagination object
		jimport('joomla.html.pagination');
		$this->_page = new JPagination($this->getState('total'), $this->getState('limitstart'), $this->getState('limit'));


		return $this->_data;
	}

	public static function getMemberData($id) {
#echo "<h1>".__FILE__."</h1>";
#print_r($params);
#echo "<hr/>";
		$db		=& JFactory::getDBO();
		// Lets load the data if it doesn't already exist
		$query = "
			SELECT 
				m.member_from, 
				m.member_until, 
				m.passport AS member_passport,
				s.section_id,
				s.section
			FROM #__clubmanagement_membership AS m
			LEFT JOIN #__clubmanagement_sections AS s ON m.section_id = s.section_id
			WHERE m.people_id = '".intval($id)."'
			";
		$db->setQuery($query);
#echo $db->getQuery();
		
		return $db->loadObjectlist();
	}


	/**
	*	Returns the current membership state
	*	@param int $id people id
	*	@param int $section relevant section
	*	@return 0 in case of no membership; n>0 in case of membership; FALSE if error occured
	*/
	public static function isMember($id, $section = FALSE) {
		$db		=& JFactory::getDBO();
		$where = ((intval($section)>0) ? " AND m.section_id = '".intval($section)."' " : "");
		$query = "
				SELECT 
					SUM(IF ((CURDATE() BETWEEN m.member_from AND m.member_until) OR m.member_until IS NULL, 1, 0)) AS memberstate
				FROM #__clubmanagement_membership AS m
				WHERE m.people_id = '".intval($id)."'".
				$where;
		$db->setQuery($query);
#		echo $db->getQuery();
		return $db->loadResult();
	}

	/**
	*	Returns people ids of this member state
	*	@param bool $member Show either members or not members
	*	@param int $section Show only this section
	*	@return Array Unordered list of people_id
	*/
	public static function getByMemberState($member = TRUE, $section = FALSE) {
		$db		= & JFactory::getDBO();
		$where 	= array();
		if ($section>0) {
			$where[] = "m.section_id = '".intval($section)."'";
		}
		if ($member) {
			$where[] = "(CURDATE() BETWEEN m.member_from AND m.member_until) OR m.member_until IS NULL";
		} else {
			$where[] = "NOT ((CURDATE() BETWEEN m.member_from AND m.member_until) OR m.member_until IS NULL)";
		}
		$query = "SELECT m.people_id FROM #__clubmanagement_membership AS m WHERE ".implode(" AND ", $where);
		$db->setQuery($query);
#		echo $db->getQuery();
		return array_unique($db->loadResultArray());
	}
	

	function getPagination()
	{
		if (is_null($this->_list) || is_null($this->_page)) {
			$this->getLists();
		}
		return $this->_page;
	}

	function store()
	{
		$row =& $this->getTable();
		$data = JRequest::get( 'post' );
		//	delete first
		if (is_array($data['deleteMembership']) && count($data['deleteMembership'])>0) {
			$this->delete($data['deleteMembership']);
		} else {
			$data['deleteMembership'] = array();
		}
		//	get update ids
		if(is_array($data['changeMembership']) && count($data['changeMembership'])>0) {
			$update = array_values(array_diff($data['changeMembership'], $data['deleteMembership']));
		}

		$return = TRUE;
		for($i=0; $i<count($update); $i++) {
			$m = array();
			$m['membership_id'] = $update[$i];
			$m['people_id'] 	= $data['people_id'];
			$m['member_from'] 	= ((empty($data['member_from_'.$update[$i]]) || ($data['member_from_'.$update[$i]]=='0000-00-00')) ? NULL : $data['member_from_'.$update[$i]]);
			$m['member_until'] 	= ((empty($data['member_until_'.$update[$i]]) || ($data['member_until_'.$update[$i]]=='0000-00-00')) ? NULL : $data['member_until_'.$update[$i]]);
			$m['section_id'] 	= $data['member_section_'.$update[$i]];
			$m['passport'] 		= $data['member_passport_'.$update[$i]];

			// Bind the form fields to the hello table
			if (!$row->bind($m)) {
				$this->setError($this->_db->getErrorMsg());
				$return = FALSE;
			}

			// Make sure the hello record is valid
			if (!$row->check()) {
				$this->setError($this->_db->getErrorMsg());
				$return = FALSE;
			}
			// Store the web link table to the database
			$tmp = $row->store(TRUE);
			if (!$tmp) {
				$this->setError( $row->getErrorMsg() );
				$return = FALSE;
			}
			ChangelogHelper::log(JFactory::getDBO()->getQuery(), $tmp);
		}

		if (!empty($data['member_from_0']) && !empty($data['member_section_0'])) {
			$m = array();
			$m['people_id'] 	= $data['people_id'];
			$m['member_from'] 	= $data['member_from_0'];
			$m['member_until'] 	= ((empty($data['member_until_0']) || ($data['member_until_0']=='0000-00-00')) ? NULL : $data['member_until_0']);
			$m['section_id'] 	= $data['member_section_0'];
			$m['passport'] 		= $data['member_passport_0'];

			// Bind the form fields to the hello table
			if (!$row->bind($m)) {
				$this->setError($this->_db->getErrorMsg());
				$return = FALSE;
			}

			// Make sure the hello record is valid
			if (!$row->check()) {
				$this->setError($this->_db->getErrorMsg());
				$return = FALSE;
			}
			// Store the web link table to the database
			$tmp = $row->store(TRUE);
			if (!$tmp) {
				$this->setError( $row->getErrorMsg() );
				$return = FALSE;
			}
			ChangelogHelper::log(JFactory::getDBO()->getQuery(), $tmp);
		}
		return $return;
	}


	function delete($cids=NULL) {
		$db		=& $this->getDBO();
		
		if (is_array($cids) && count($cids)>0) {
			
		} else {
			$cids = JRequest::getVar( 'cid', array(0), 'post', 'array' );
		}
#print_r($row);
#print_r($cids);
		if (count( $cids ))
		{
			JArrayHelper::toInteger($cids);
			$cids = implode(",", $cids);
			$query = "DELETE FROM #__clubmanagement_membership WHERE people_id IN (".$cids.")";
			$db->setQuery($query);
#echo $db->getQuery();
			$return = $db->query();
			ChangelogHelper::log($query, $return);
		}
		return $return;
	}

	function &getLists() {
#		global $mainframe;
		$mainframe = JFactory::getApplication();
		$context= 'com_clubmanagement.members.list.';
		$lists = array();

		$filter	= null;

		$filter_order= JFactory::getApplication()->getUserStateFromRequest( $context.'filter_order', 'filter_order', 'surname');
		$filter_order_Dir= JFactory::getApplication()->getUserStateFromRequest($context.'filter_order_Dir', 'filter_order_Dir', 'ASC');
		$filter_state_sex = JFactory::getApplication()->getUserStateFromRequest($context.'filter_state_sex', 'filter_state_sex', 0);
		$filter_byDate = JFactory::getApplication()->getUserStateFromRequest($context.'filter_byDate', 'filter_byDate', NULL);
		$filter_section = JFactory::getApplication()->getUserStateFromRequest($context.'filter_section', 'filter_section', NULL);

		// table ordering
		$lists['order_Dir']	= $filter_order_Dir;
		$lists['order']		= $filter_order;

		//	Filter
		$lists["filter_state_sex"] 	= $filter_state_sex;
		$lists["filter_byDate"] 	= $filter_byDate;
		$lists["filter_section"] 	= $filter_section;
		$this->_list = $lists;
		return $lists;
	}

}
