<?php

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();
jimport('joomla.application.component.model');

class ClubmanagementModelTournaments extends JModel
{
	/**
	 * Constructor that retrieves the ID from the request
	 *
	 * @access	public
	 * @return	void
	 */
	function __construct()
	{
		parent::__construct();

		// Get pagination request variables
		$limit = JFactory::getApplication()->getUserStateFromRequest('global.list.limit', 'limit', JFactory::getApplication()->getCfg('list_limit'), 10);
		$limitstart = JFactory::getApplication()->getUserStateFromRequest($option.'.limitstart', 'limitstart', 0, 0);

		// In case limit has been changed, adjust it
		$limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);

		$this->setState('limit', $limit);
		$this->setState('limitstart', $limitstart);
		$this->getLists();
	}

	function &getLists() {
		if(empty($this->_lists)) {
			$context= 'com_clubmanagement.tournaments.list.';
			$filter	= null;

			//$search				= JFactory::getApplication()->getUserStateFromRequest($context."search", 'search', '',	'string');
			//$search				= JString::strtolower($search);

			$filter_order= JFactory::getApplication()->getUserStateFromRequest( $context.'com_clubmanagement_tournaments_filter_order', 'com_clubmanagement_tournaments_filter_order');
			if (!$filter_order) {
				$filter_order = 'title';
			}
			$filter_order_Dir= JFactory::getApplication()->getUserStateFromRequest($context.'com_clubmanagement_tournaments_filter_order_Dir', 'com_clubmanagement_tournaments_filter_order_Dir');
			//$search = JFactory::getApplication()->getUserStateFromRequest($context.'search','search', '' );

			// table ordering
			$lists['order_Dir']	= $filter_order_Dir;
			$lists['order']		= $filter_order;

			// search filter
			//$lists['search'] = $search;

			//	Filter
			$lists['filter_category'] = JFactory::getApplication()->getUserStateFromRequest($context.'filter_category', 'filter_category');

			$this->_lists = $lists;
//print_r($this->_lists);
		}
		return $this->_lists;

	}

	function getPagination()
	{
		// Create the pagination object
		jimport('joomla.html.pagination');
		$this->_page = new JPagination($this->getState('total'), $this->getState('limitstart'), $this->getState('limit'));
		return $this->_page;
	}

	public function getBridges() {
		$path_parts = pathinfo(__FILE__);
		$d = array();
		$ret = JFolder::files($path_parts['dirname'], $path_parts['filename'], FALSE, FALSE, array($path_parts['basename']));
		for($i=0; $i<count($ret); $i++) {
			$tmp = str_replace(array($path_parts['filename'].'.', '.'.$path_parts['extension']), "", $ret[$i]);
			$d[$i] = (object) array("text"=>ucfirst($tmp), "id"=>strtolower($tmp));
		}
		return $d;
	}

	public function getData($cid = NULL) {
		if (empty($this->_data) || TRUE) {
			$params = &JComponentHelper::getParams( 'com_clubmanagement' );
			require_once(JPATH_ADMINISTRATOR .DS. 'components' .DS. 'com_clubmanagement' .DS. 'models' . DS . 'tournaments.'.$params->get('tournamentbridgelist').'.php');
			$model = & JModel::getInstance('tournaments'.$params->get('tournamentbridgelist'),'ClubmanagementModel');
			$this->_data = $model->getTournaments($cid);
			if (!is_null($cid)) {
				$this->_id = intval($cid);
			}
		}
		return $this->_data;
			
	}
	public function getCategories() {
		if (empty($this->_categories)) {
//echo __FILE__;
//echo "<hr/>";
			$params = &JComponentHelper::getParams( 'com_clubmanagement' );
			require_once(JPATH_ADMINISTRATOR .DS. 'components' .DS. 'com_clubmanagement' .DS. 'models' . DS . 'tournaments.'.$params->get('tournamentbridgelist').'.php');
			$model = & JModel::getInstance('tournaments'.$params->get('tournamentbridgelist'),'ClubmanagementModel');
			$this->_categories = $model->getCategories();
		}
		return $this->_categories;
	}
	
	public function getPositions($cid = NULL) {
		if (!is_null($cid)) {
			$cid = intval($cid);
		} else if (!is_null($this->_id)) {
			$cid = intval($this->_id);
		} else {
			return FALSE;
		}
		$db		=& $this->getDBO();
		$query = "SELECT 
					tp.tournament_id, 
					p.people_id,
					CONCAT(p.surname, ', ', p.name) AS name_complete,
					tp.position 
				FROM #__clubmanagement_tournamentpositions AS tp
				INNER JOIN #__clubmanagement_people AS p ON tp.people_id = p.people_id
				WHERE tournament_id = '".$cid."'
				ORDER BY position ";
		$db->setQuery($query);
//echo $db->getQuery();
		$result = $db->loadObjectlist();
		return $result;
	}

	function store()
	{
		$db		=& JFactory::getDBO();
		$row =& $this->getTable('tournamentpositions');
//echo "<h1>STORE</h1>";
		$d = JRequest::getVar( 'rawdata' );
		$tournament_id = JRequest::getVar('tournament_id');
		$keys = unserialize(JRequest::getVar('tpkeys'));
		//print_r($keys);
		$d = json_decode($d);
		$data = array();
		$this->delete("tournament", $tournament_id);
		$return = TRUE;
		for($i=0; $i<count($d); $i++) {

			$tmp = array_combine($keys, $d[$i]);
			if (!$tmp['position']>0) {continue;}
			$tmp['tournament_id'] = $tournament_id;
			$tmp['tournamentposition_id'] = 0;
			unset($tmp['name_complete']);

			if (!$row->bind($tmp)) {
				$this->setError($this->_db->getErrorMsg());
				$return &= FALSE;
			}

			if (!$row->check()) {
				$this->setError($db	->getErrorMsg());
				$return &= FALSE;
			}

			if (!$row->store()) {
				//$this->setError( $row->getErrorMsg() );
				$return &= FALSE;
			}

		}

		//ChangelogHelper::log($db->getQuery(), $tmp);
		return $return;
	}

	function delete($type, $id)
	{
		$db		=& JFactory::getDBO();
		switch($type) {
			case "people":
				$row = "people_id";
			break;
			case "tournament":
				$row = "tournament_id";
			break;
			default:
				return FALSE;
			break;
		}
		if (is_array($id)) {
			JArrayHelper::toInteger($id);
			$where = $row." IN (".implode(",", $id).")";
		} else {
			$where = $row." = ".intval($id);
		}
		$query = "DELETE FROM #__clubmanagement_tournamentpositions WHERE ".$where;
		$db->setQuery($query);
		$tmp = $db->query();
		ChangelogHelper::log(JFactory::getDBO()->getQuery(), $tmp);
		return $tmp;
	}


}
?>
