<?php

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();
jimport('joomla.application.component.model');

class ClubmanagementModelMembers extends JModel
{
	private static $_lists = NULL;
	public static function getYearschart() {
		$db = JFactory::getDBO();

		$lists = self::getLists();
		$filter_fromdate		= $lists["filter_fromdate"];
		$filter_untildate		= $lists["filter_untildate"];
		$filter_date			= $lists["filter_date"];

		if($lists["filter_male_members"]==1) {
			$queryMaleMembers = self::getSubqueryMembers('p1.sex="m"');
		} else {
			$queryMaleMembers = "NULL";
		}
		if($lists["filter_female_members"]==1) {
			$queryFemaleMembers = self::getSubqueryMembers('p1.sex="f"');
		} else {
			$queryFemaleMembers = "NULL";
		}
		$queryMembers = self::getSubqueryMembers('');
		//$queryMembers_30less = self::getSubqueryMembers('(YEAR(dates)-YEAR(p1.birthday))<10');

		$where1 = array();
		$where2 = array();

		if (strtotime($fromdate = addslashes(JRequest::getVar('fromdate')))) {
			$where1[] = 'm.member_from>=\''.$fromdate.'\'';
			$where2[] = 'm.member_until>=\''.$fromdate.'\'';
		} else {
			$where1[] = '1';
			$where2[] = '1';
		}
		if (strtotime($untildate = addslashes(JRequest::getVar('untildate')))) {
			$where1[] = 'm.member_from<=\''.$untildate.'\'';
			$where2[] = 'm.member_until<=\''.$untildate.'\'';
		} else {
			$where1[] = '1';
			$where2[] = '1';
		}

		$where1 = " AND ".implode(" AND ", $where1);
		$where2 = " AND ".implode(" AND ", $where2);
		$query = "
				SELECT
					m.member_from AS dates,
					TO_DAYS(m.member_from) AS days,
					(".$queryMaleMembers.") AS members_male,
					(".$queryFemaleMembers.") AS members_female,
					(".$queryMembers.") AS members_sum

				FROM #__clubmanagement_membership AS m
				LEFT JOIN #__clubmanagement_people AS p ON m.people_id = p.people_id
				WHERE 
				m.member_from IS NOT NULL
				".$where1."
				GROUP BY m.member_from

				UNION

				SELECT
					m.member_until AS dates,
					TO_DAYS(m.member_until) AS days,
					(".$queryMaleMembers.") AS members_male,
					(".$queryFemaleMembers.") AS members_female,
					(".$queryMembers.") AS members_sum

				FROM #__clubmanagement_membership AS m
				LEFT JOIN #__clubmanagement_people AS p ON m.people_id = p.people_id
				WHERE 
				m.member_until IS NOT NULL
				".$where2."
				GROUP BY m.member_until
				";
/**
				LIMIT 0,5

*/

		$db->setQuery($query);
		return $db->loadObjectlist();
	}

	private static function getSubqueryMembers($where = '') {
		if(empty($where)) {
			$where = 1;
		}
		$query = "
			SELECT 
				COUNT(p1.people_id)
			FROM #__clubmanagement_membership AS m1 
			LEFT JOIN #__clubmanagement_people AS p1 ON m1.people_id = p1.people_id 
			WHERE (m1.member_from <= dates OR m1.member_from IS NULL) 
			AND (m1.member_until>=dates OR m1.member_until IS NULL) 
			AND ".$where;
		return $query;
	}

	public static function drawYearschart() {
		$rawdata = self::getYearschart();
#print_r($rawdata);
		require_once( JPATH_ADMINISTRATOR .DS. 'components' .DS. 'com_clubmanagement' .DS. '3rdparty' . DS . 'mtchart' . DS . 'mtChart.php' );

		// Dataset definition
		$Test = new mtChart(500,500);

		$data = array();

		$cachepath =JFactory::getCache()->_options['cachebase'].DS.'com_clubmanagement';
		if (!file_exists($cachepath)) {
			mkdir($cachepath);
		} 
		if (is_writable($cachepath)){
#			$Test->enableCaching(__FILE__."_".__FUNCTION__, $cachepath);
		}

		if (count($rawdata)>0 && is_array($rawdata)) {
			for($i=0; $i<count($rawdata); $i++) {
				$data['days'][] = $rawdata[$i]->days;
				$data['members_male'][] = $rawdata[$i]->members_male;
				$data['members_female'][] = $rawdata[$i]->members_female;
				$data['members_sum'][] = $rawdata[$i]->members_sum;
				//$data['members_30less'][] = $rawdata[$i]->members_30less;
			}
		} else {
			$data['days'] = NULL;
			$data['members_male'] = NULL;
			$data['members_female'] = NULL;
			$data['members_sum'] = NULL;
			//$data['members_30less'] = NULL;
		}

		$Test->AddPoint($data['members_male'],"Serie3");
		$Test->AddPoint($data['days'],"Serie4");
		$Test->AddPoint($data['members_female'],"Serie5");
		$Test->AddPoint($data['days'],"Serie6");
		$Test->AddPoint($data['members_sum'],"Serie1");
		$Test->AddPoint($data['days'],"Serie2");
		//$Test->AddPoint($data['members_30less'],"Serie7");
		//$Test->AddPoint($data['days'],"Serie8");
		$Test->AddAllSeries();
		$Test->setSerieName(JText::_('COM_CLUBMANAGEMENT_TOTAL'), 'Serie1');
		$Test->setSerieName(JText::_('COM_CLUBMANAGEMENT_MALE_MEMBERS'), 'Serie3');
		$Test->setSerieName(JText::_('COM_CLUBMANAGEMENT_FEMALE_MEMBERS'), 'Serie5');
		//$Test->setSerieName('Junge Leute', 'Serie7');

		$Test->SetXAxisName("Jahre");
		$Test->SetYAxisName("Mitgliederzahlen");
		$Test->setXAxisFormat('date');  
		$Test->setXAxisFormat('days');  
		$Test->setXAxisUnit('');  
		$Test->setYAxisUnit('');  
		$Test->setDateFormat("Y");

		// Initialise the graph
		$Test->drawGraphAreaGradient(0,0,0,-100,TARGET_BACKGROUND);

		// Prepare the graph area
		$Test->setGraphArea(55,55,480,400);

		#$Test->drawGraphArea(213,217,221,FALSE);
		$Test->drawGraphAreaGradient(30,30,30,-50);

		$Test->clearScale();
		$Test->setScaleMultiaxis(array('Serie2', 'Serie4', 'Serie6'), array('Serie1', 'Serie3', 'Serie5'));
		$Test->drawXYScale("Serie1","Serie2",213,217,221,TRUE,90);
		$Test->drawGrid(4,TRUE,230,230,230,20);

		$Test->drawXYPlotGraph("Serie3","Serie4");
		$Test->drawXYPlotGraph("Serie5","Serie6");
		//$Test->drawXYPlotGraph("Serie7","Serie8");
		$Test->drawXYPlotGraph("Serie1","Serie2");

		// Draw the legend
		$Test->RemoveSerie("Serie2");
		$Test->RemoveSerie("Serie4");
		$Test->RemoveSerie("Serie6");
		//$Test->RemoveSerie("Serie8");

		$Test->drawLegend(160,5,0,0,0,0,0,0,255,255,255,FALSE);
		//$Test->Render($cachepath.DS.'test.png');
		$Test->Stroke();
	}

	public function &getLists() {
		if (is_null(self::$_lists)) {
			$context= 'com_clubmanagement.members.list.';

			$filter_fromdate = JFactory::getApplication()->getUserStateFromRequest($context.'filter_fromdate', 'filter_fromdate', "");
			$filter_untildate = JFactory::getApplication()->getUserStateFromRequest($context.'filter_untildate', 'filter_untildate', "");
			$filter_date = JFactory::getApplication()->getUserStateFromRequest($context.'filter_date', 'filter_date', "");
			$filter_male_members = JFactory::getApplication()->getUserStateFromRequest($context.'filter_male_members', 'filter_male_members', 1);
			$filter_female_members = JFactory::getApplication()->getUserStateFromRequest($context.'filter_female_members', 'filter_female_members', 1);

			//	Filter
			$lists["filter_fromdate"] 	= $filter_fromdate;
			$lists["filter_untildate"] 	= $filter_untildate;
			$lists["filter_date"] 		= $filter_date;
			$lists["filter_male_members"] 	= $filter_male_members;
			$lists["filter_female_members"]	= $filter_female_members;
			self::$_lists = $lists;
		}
		return self::$_lists;
	}
	
	//public function getQuery() {
	//	return self::$query;
	//}
	
	public static function getAgegroupstatistics($filterdate=NULL) {
		$db = JFactory::getDBO();

		$lists = &self::getLists();
		$filter_date = $lists['filter_date'];
		if (!empty($filter_date)) {
			if ($f=strtotime($filter_date)) {
				$filterdate = "'".date('Y-m-d', $f)."'";
			} else {
				$filterdate = "CURRENT_DATE";
				self::$_lists['filter_date'] = date('Y-m-d');
			}
		} else {
			$filterdate = "CURRENT_DATE";
			self::$_lists['filter_date'] = date('Y-m-d');
		}
		//echo ($filter_date)."++++++++++";
		//echo strtotime($filter_date)."++++++++++";
		//$filter_date = (!empty($filter_date) ? date('Y-m-d', strtotime($filter_date)) : NULL);
		//$filterdate = (!is_null($filter_date) ? "'".$filter_date."'" : "CURRENT_DATE");
		$query = "
SELECT 
	a.description AS description, a.agegroup_id, a.age_from, a.age_until,
	(
		SELECT 
			COUNT(p1.people_id) 
		FROM #__clubmanagement_people AS p1
		INNER JOIN #__clubmanagement_membership AS m ON m.people_id = p1.people_id 
		WHERE 1
		AND (m.member_from <= ".$filterdate." OR m.member_from IS NULL) AND (m.member_until>=".$filterdate." OR m.member_until IS NULL) 
		AND (
			((
				(((YEAR(".$filterdate.") - YEAR(p1.birthday)) = a.age_from) AND ((DAYOFYEAR(".$filterdate.")-DAYOFYEAR(p1.birthday))>=0))
				OR
				((YEAR(".$filterdate.") - YEAR(p1.birthday)) > a.age_from)
				OR
				(a.age_from IS NULL)
			)
			AND (
				((YEAR(".$filterdate.") - YEAR(p1.birthday)) < (a.age_until+1))
				OR
				(((YEAR(".$filterdate.") - YEAR(p1.birthday)) = (a.age_until+1)) AND ((DAYOFYEAR(".$filterdate.")-DAYOFYEAR(p1.birthday))<0))
				OR
				(a.age_until IS NULL)
			)) 
		)
		AND (m.member_from IS NOT NULL OR m.member_until IS NOT NULL)
		AND p1.sex='m' 
	) AS members_male,
	(
		SELECT 
			COUNT(p1.people_id) 
		FROM #__clubmanagement_people AS p1
		INNER JOIN #__clubmanagement_membership AS m ON m.people_id = p1.people_id 
		WHERE 1
		AND (m.member_from <= ".$filterdate." OR m.member_from IS NULL) AND (m.member_until>=".$filterdate." OR m.member_until IS NULL) 
		AND (
			((
				(((YEAR(".$filterdate.") - YEAR(p1.birthday)) = a.age_from) AND ((DAYOFYEAR(".$filterdate.")-DAYOFYEAR(p1.birthday))>=0))
				OR
				((YEAR(".$filterdate.") - YEAR(p1.birthday)) > a.age_from)
				OR
				(a.age_from IS NULL)
			)
			AND (
				((YEAR(".$filterdate.") - YEAR(p1.birthday)) < (a.age_until+1))
				OR
				(((YEAR(".$filterdate.") - YEAR(p1.birthday)) = (a.age_until+1)) AND ((DAYOFYEAR(".$filterdate.")-DAYOFYEAR(p1.birthday))<0))
				OR
				(a.age_until IS NULL)
			)) 
		)
		AND (m.member_from IS NOT NULL OR m.member_until IS NOT NULL)
		AND p1.sex='f' 
	) AS members_female
FROM #__clubmanagement_agegroups AS a
WHERE 1
ORDER BY a.age_from, a.age_until
		";
		$db->setQuery($query);
		//self::$query = $db->getQuery();
//echo "<h1>asdf</h1>";
//echo $db->getQuery();
//echo "<hr/>";
		//$rawdata = $db->loadObjectlist();
		//return $rawdata;
		$tmp = $db->loadObjectlist();

		return $tmp;
	}
	public static function drawAgegroupschart() {
		$rawdata = self::getAgegroupstatistics();
		require_once( JPATH_ADMINISTRATOR .DS. 'components' .DS. 'com_clubmanagement' .DS. '3rdparty' . DS . 'mtchart' . DS . 'mtChart.php' );

		// Dataset definition
		$Test = new mtChart(700,400);

		$data = array();

		$cachepath =JFactory::getCache()->_options['cachebase'].DS.'com_clubmanagement';
		if (!file_exists($cachepath)) {
			mkdir($cachepath);
		} 
		if (is_writable($cachepath)){
#			$Test->enableCaching(__FILE__."_".__FUNCTION__, $cachepath);
		}

		if (count($rawdata)>0 && is_array($rawdata)) {
			for($i=0; $i<count($rawdata); $i++) {
				$data['members_male'][] = $rawdata[$i]->members_male;
				$data['members_female'][] = $rawdata[$i]->members_female;
				$data['description'][] = $rawdata[$i]->description;
				//$data['members_30less'][] = $rawdata[$i]->members_30less;
			}
		} else {
			$data['members_male'] = NULL;
			$data['members_female'] = NULL;
			$data['description'] = NULL;
			//$data['members_30less'] = NULL;
		}

		$Test->AddPoint($data['description'],"Serie1");
		$Test->AddPoint($data['members_male'],"Serie2");
		$Test->AddPoint($data['members_female'],"Serie3");

$Test->addAllSeries();
$Test->RemoveSerie("Serie1");
$Test->setAbsciseLabelSerie("Serie1");

//$Test->setSerieName("January","Serie1");
$Test->setSerieName(JText::_('COM_CLUBMANAGEMENT_MALE_MEMBERS'),"Serie2");
$Test->setSerieName(JText::_('COM_CLUBMANAGEMENT_FEMALE_MEMBERS'),"Serie3");

		// Initialise the graph
		$Test->drawGraphAreaGradient(0,0,0,-100,TARGET_BACKGROUND);

		// Prepare the graph area
		$Test->setGraphArea(55,10,680,200);

		$Test->drawGraphArea(213,217,221,FALSE);
		$Test->drawGraphAreaGradient(30,30,30,-50);


// Initialise the graph
$Test->setFontProperties('DejaVuSansCondensed',8);
//$Test->drawFilledRoundedRectangle(7,7,693,393,5,240,240,240);
//$Test->drawRoundedRectangle(5,5,695,395,5,230,230,230);
//$Test->drawGraphArea(255,255,255,TRUE);


$Test->drawScale(SCALE_NORMAL,213,217,221,TRUE,90,2,TRUE);
		$Test->drawGrid(4,TRUE,230,230,230,20);

// Draw the 0 line
$Test->setFontProperties('DejaVuSansCondensed',6);
$Test->drawTreshold(0,143,55,72,TRUE,TRUE);

// Draw the bar graph
$Test->drawBarGraph(TRUE,80);

// Finish the graph
$Test->setFontProperties('DejaVuSansCondensed',8);
$Test->drawLegend(500,20,255,255,255);

$Test->setFontProperties('DejaVuSansCondensed',10);
$Test->Stroke();
	}

	public function getSectionmembers($sid) {
		$db = JFactory::getDBO();
		$query = "
			SELECT 
				p.people_id, 
				p.sex, 
				p.name, 
				p.surname,
				CONCAT(p.surname, ', ', p.name) AS name_complete, 
				m.member_from,
				m.member_until,
				m.passport
			FROM #__clubmanagement_membership AS m
			LEFT JOIN #__clubmanagement_people AS p ON m.people_id = p.people_id
			WHERE m.section_id = '".intval($sid)."'
			AND ((CURDATE() BETWEEN m.member_from AND m.member_until) OR (CURDATE()>=m.member_from AND m.member_until IS NULL))
			GROUP BY p.people_id
			ORDER BY p.surname			
			";

		$db->setQuery($query);
		$db->setQuery($query, $this->getState('limitstart'), $this->getState('limit'));
		return $this->_data = $db->loadObjectlist();
	}

	public function getSectiondata($sid) {
	
	}
}
?>