<?php
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

class ClubmanagementControllerTournaments extends ClubmanagementController
{
	/**
	 * constructor (registers additional tasks to methods)
	 * @return void
	 */
	function __construct()
	{
		parent::__construct();

		// Register Extra tasks
#		JSubMenuHelper::addEntry(JText::_('positionsAdmin'), 'index.php?option=com_clubmanagement&view=positionsAdmin');
		$model4 = $this->getModel('tournaments');
		$view  = $this->getView('tournaments', 'html');
		$view->setModel($model4);
		$model = $this->getModel ('people');
		$view->setModel($model, TRUE);
		$this->registerTask( 'apply', 'save' );

	}
	
	function add()
	{
		$view  = $this->getView('tournaments', 'html');
		$model1 = $this->getModel ('tournaments');
		$view->setModel($model1, TRUE);
		JRequest::setVar( 'view', 'tournaments' );
		JRequest::setVar( 'layout', 'add'  );
		JRequest::setVar( 'layout', 'form'  );
		JRequest::setVar('hidemainmenu', 1);
		parent::display();
	}

	function edit()
	{
		JRequest::setVar( 'view', 'tournaments' );
		JRequest::setVar( 'layout', 'form'  );
		JRequest::setVar('hidemainmenu', 1);
		parent::display();
	}


	function save()
	{
		$model = $this->getModel('tournaments');
		if ($model->store($post)) {
		  $msg = JText::_( 'tournaments Saved!' );
		} else {
		  $msg = JText::_( 'Error Saving tournaments' );
		}

		switch (JRequest::getCmd( 'task' ))
		{
			case 'apply':
				$cid	= intval(JRequest::getVar('tournament_id'));
				$link =  'index.php?option=com_clubmanagement&view=tournaments&task=edit&cid[]='. $cid ;
				$this->setRedirect($link, $msg);
			break;
			default:
				$link = 'index.php?option=com_clubmanagement&view=tournaments';
				$this->setRedirect($link, $msg);
			break;
		}


	}

	/**
	 * cancel editing a record
	 * @return void
	 */
	function cancel()
	{
		$msg = JText::_( 'Operation Cancelled' );
		$this->setRedirect( 'index.php?option=com_clubmanagement&view=tournaments', $msg );
	}

	/**
	 * remove record(s)
	 * @return void
	 */
	function remove()
	{
		$model = $this->getModel('tournaments');
		if(!$model->delete('people_id')) {
			$msg = JText::_( 'Error: One or more Clubmanagements could not be Deleted' );
		} else {
			$msg = JText::_( 'Clubmanagement(s) Deleted' );
		}
		$this->setRedirect( 'index.php?option=com_clubmanagement&view=tournaments', $msg );
	}
	
}
?>
