<?php
class AdministrationHelper {
	public static function renderFormfield(stdClass $field, $editUserId) {
		$edit = ClubmanagementModeladministration::getRights($editUserId);
		$current = ClubmanagementModeladministration::getRights();

		if (is_null($edit->getValue($field->name))) {
			$selected = $field->default;
		} else {
			$selected = intval($edit->getValue($field->name));
		}
		if (!($current->getValue($field->name)) || JFactory::getUser($editUserId)->usertype=="Super Administrator") {
			$readonly = TRUE;
		} else {
			$readonly = FALSE;
		}

		switch($field->type) {
			case "boolean":
				$return = "<div class=\"formfield\">";
				$return .= "<span class=\"label\">".$field->name."</span>";
				$readonly = (($readonly) ? "disabled=\"disabled\" " : "");
				$return .= JHTML::_("select.booleanlist", $field->name, $readonly, $selected);
				$return .= "</div>";
			break;
			case "intarraymulti":
				#print_r($field);
				array_unshift($field->possible, (object) array("value"=>0, "text"=>"asdfdas"));
				$return = "<div class=\"formfield\">";
				$return .= "<span class=\"label\">".$field->name."</span>";
				$readonly = (($readonly) ? "disabled=\"disabled\" " : "");
				$return .= JHTML::_("select.genericlist", $field->possible, $field->name, $readonly."multiple=\"multiple\" size=\"3\"", "value", "text", $selected);
				$return .= "</div>";
			break;
			default:
			
			break;
		}
		return $return;
	}
	
	public static function getJoomlaUser($state=NULL) {
		$db = JFactory::getDBO();
		$query = "SELECT id AS userid, name, username, usertype FROM #__users";
		$db->setQuery($query);
		$result = $db->loadObjectlist();
		for($i=0; $i<count($result); $i++) {
			$t = $result[$i];
			$r2[$result[$i]->userid] = $t;
		}
		#print_r($r2);
		return $r2;
	}
	
	public static function getJoomlaUserNotYetClubAdmins() {
		$db = JFactory::getDBO();
		$query = "SELECT 
					u.id AS userid, u.name, u.username, u.usertype
				FROM #__users AS u LEFT JOIN #__clubmanagement_administration AS a ON u.id = a.joomlauser_id
				WHERE a.joomlauser_id IS NULL";
		$db->setQuery($query);
#echo "<h1>".$db->_sql."</h1>";
		$result = $db->loadObjectlist();
		$r2 = array();
		for($i=0; $i<count($result); $i++) {
			$t = $result[$i];
			$r2[$result[$i]->userid] = $t;
		}
#print_r($r2);
		return $r2;
	}

	public static function getPeopleWithoutPositions() {
		$db = JFactory::getDBO();
		$query = "
				SELECT 
					p.people_id AS id,
					IF (p.birthday IS NULL, CONCAT(p.surname, ', ', p.name), CONCAT(p.surname, ', ', p.name, ' (', p.birthday, ')')) AS name
				FROM jos_clubmanagement_people AS p 
				LEFT JOIN jos_clubmanagement_peoplepositions AS pp ON p.people_id = pp.people_id 
				WHERE pp.position_id IS NULL 
				ORDER BY p.surname, p.name";
		$db->setQuery($query);
//echo $db->getQuery();
		return $db->loadObjectlist();
	}

}

?>