<?php

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();
jimport('joomla.application.component.model');

class ClubmanagementModelContacts extends JModel
{
	/**
	 *
	 * @access	public
	 * @return	void
	 */
	function __construct()
	{
		parent::__construct();
		$array = JRequest::getVar('cid',  0, '', 'array');
		$this->setId((int)$array[0]);
	}


	/**
	 * Method to set the hello identifier
	 *
	 * @access	public
	 * @param	int Hello identifier
	 * @return	void
	 */
	function setId($id)
	{
		// Set id and wipe data
		$this->_id		= $id;
		$this->_data	= null;
	}

	/**
	 * Method to get a hello
	 * @return object with data
	 */
	function &getData()
	{
		$db		=& $this->getDBO();
		$query = "
			SELECT
				contacts_id, people_id, contacttype_id, contactpriority, contactdata
			FROM #__clubmanagement_contacts
			WHERE people_id = '".$this->_id."'
			ORDER BY contactpriority";
		$db->setQuery($query);
		$banking = $db->loadObjectlist();
#echo "<p>".$db->getQuery()."</p>";
#print_r($banking);
		return $banking;
	}
	
	function getContactIds($pid) {
		$db	= &$this->getDBO();
		$query = "
			SELECT contacts_id
			FROM #__clubmanagement_contacts
			WHERE people_id = '".$pid."'";
		$db->setQuery($query);
		echo $db->getQuery();
		return $db->loadResultArray();
	}

	/**
	 * Method to store a record
	 *
	 * @access	public
	 * @return	boolean	True on success
	 */
	function store()
	{
		$row =& $this->getTable();

		$contacttype = JRequest::getVar("contacttype");
		$contactdata = JRequest::getVar("contactdata");
		$contactpriority = JRequest::getVar("contactpriority");
		$people_id = JRequest::getVar("people_id");
		$contacts_id = JRequest::getVar("contacts_id");
		
		$changedIds = array();
		for($i=0; $i<count($contacttype); $i++) {
			$data = new stdClass;
			$data->contacts_id = $contacts_id[$i];
			$data->contacttype_id = $contacttype[$i];
			$data->contactdata = $contactdata[$i];
			$data->contactpriority = $contactpriority[$i];
			$data->people_id = $people_id;

			// Bind the form fields to the hello table
			if (!$row->bind($data)) {
				$this->setError($this->_db->getErrorMsg());
//				continue;
			}

			// Make sure the hello record is valid
			if (!$row->check()) {
				$this->setError($this->_db->getErrorMsg());
//				continue;
			}
			// Store the web link table to the database
			$tmp = $row->store();
			if (!$tmp) {
				$this->setError( $row->getErrorMsg() );
//				continue;
			}
			ChangelogHelper::log(JFactory::getDBO()->getQuery(), $tmp);
			$changedIds[] = $row->contacts_id;
		}

		//	berflssige Daten lschen
		$tmp = array_diff ($this->getContactIds($people_id), $changedIds);
		$row =& $this->getTable();
		if (count( $tmp ))
		{
			foreach($tmp as $cid) {
				$tmp = $row->delete( $cid );
				if (!$tmp) {
					$this->setError( $row->getErrorMsg() );
					return false;
				}
				ChangelogHelper::log(JFactory::getDBO()->getQuery(), $tmp);
			}
		}
		return true;
	}

	/**
	 * Method to delete record(s)
	 *
	 * @access	public
	 * @return	boolean	True on success
	 */
	function delete($cids)
	{
		$db		=& $this->getDBO();
		
		if (is_array($cids) && count($cids)>0) {
			
		} else {
			$cids = JRequest::getVar( 'cid', array(0), 'post', 'array' );
		}

		if (count( $cids ))
		{
			JArrayHelper::toInteger($cids);
			$cids = implode(",", $cids);
			$query = "DELETE FROM #__clubmanagement_contacts WHERE people_id IN (".$cids.")";
			$db->setQuery($query);
#echo $db->getQuery();
			$return = $db->query();
			ChangelogHelper::log($query, $return);
		}
		return $return;
	}


	function getPagination()
	{
		if (is_null($this->_page)) {
			// Create the pagination object
			jimport('joomla.html.pagination');
			$this->_page = new JPagination(0, 0, 0);
		}
		return $this->_page;
	}
	
	public static function getTypes($blankItem = TRUE) {
		$db =& JFactory::getDBO();
		$query = "SELECT id AS contacttype_id, title AS contact FROM #__categories WHERE section = 'com_clubmanagementContacttypes' ORDER BY title ASC";
		$db->setQuery($query);
		$result = $db->loadObjectlist();
		if ($blankItem) {
			array_unshift($result, (object) array("contacttype_id"=>0, "contact"=>JText::_("COM_CLUBMANAGEMENT_CHOSE_CONTACT")));
		}
		return $result;
	}
}
?>
