<?php

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();
jimport('joomla.application.component.model');

class ClubmanagementModelPeople extends JModel
{
	/**
	 * Constructor that retrieves the ID from the request
	 *
	 * @access	public
	 * @return	void
	 */
	function __construct()
	{
		parent::__construct();

		$tmp = JRequest::getVar('cid',  NULL);
		$this->setId((int)$tmp[0]);

		// Get pagination request variables
		$limit = JFactory::getApplication()->getUserStateFromRequest('global.list.limit', 'limit', JFactory::getApplication()->getCfg('list_limit'), 10);
		$limitstart = JFactory::getApplication()->getUserStateFromRequest($option.'.limitstart', 'limitstart', 0, 0);

		// In case limit has been changed, adjust it
		$limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);

		$this->setState('limit', $limit);
		$this->setState('limitstart', $limitstart);
		$this->getLists();

	}

	function &getLists() {
		$context= 'com_clubmanagement.people.list.';
		$filter	= null;

		$search				= JFactory::getApplication()->getUserStateFromRequest($context."search", 'search', '',	'string');
		$search				= JString::strtolower($search);

		$filter_surname_firstchar =  JFactory::getApplication()->getUserStateFromRequest( $context.'filter_surname_firstchar', 'filter_surname_firstchar');

		$filter_order= JFactory::getApplication()->getUserStateFromRequest( $context.'filter_order', 'filter_order');
		if (!$filter_order) {
			$filter_order = 'surname';
		}
		$filter_order_Dir= JFactory::getApplication()->getUserStateFromRequest($context.'filter_order_Dir', 'filter_order_Dir');
		$filter_state_member = JFactory::getApplication()->getUserStateFromRequest($context.'filter_state_member', 'filter_state_member', -1);
		$filter_state_sex = JFactory::getApplication()->getUserStateFromRequest($context.'filter_state_sex', 'filter_state_sex');
		$search = JFactory::getApplication()->getUserStateFromRequest($context.'search','search', '' );

		// table ordering
		$lists['order_Dir']	= $filter_order_Dir;
		$lists['order']		= $filter_order;

		// search filter
		$lists['search'] = $search;

		//	Filter
		$lists["filter_surname_firstchar"] = $filter_surname_firstchar;
		$lists["filter_state_member"] = $filter_state_member;
		$lists["filter_state_sex"] = $filter_state_sex;

		return $lists;

	}

	function &getFirstChars() {
		$db		=& JFactory::getDBO();
		$query = "SELECT LOWER(LEFT(surname, 1)) AS value, UPPER(LEFT(surname, 1)) AS text FROM #__clubmanagement_people GROUP BY value ORDER BY value";
#echo "<h1>".$query."</h1>";
		$db->setQuery($query);
		$return = $db->loadObjectList ();
		return $return;
	}

	/**
	 * Method to set the hello identifier
	 *
	 * @access	public
	 * @param	int Hello identifier
	 * @return	void
	 */
	function setId($id)
	{
		// Set id and wipe data
		$this->_id		= $id;
		$this->_data	= null;
	}

	/**
	 * @return object with data
	 */
	function &getData()
	{

		$db		=& JFactory::getDBO();
		$lists = $this->getLists();
		$filter_order		= $lists["order"];
		$filter_order_Dir	= $lists["order_Dir"];
		$search = $lists["search"];
		$filter_surname_firstchar = $lists["filter_surname_firstchar"];
		$filter_state_member = $lists["filter_state_member"];
		$filter_state_sex = $lists["filter_state_sex"];
		$where = array();
		
		switch(JRequest::getVar('task')) {
			case "add":
			break;
			case "edit":
				if(!is_null($this->_id)) {
//var_dump($this->_id);
					$where[] = "p.people_id = ".intval($this->_id);
					$this->setState('limitstart', NULL);
					$this->setState('limit', NULL);
				}
			break;
			default:
				// Keyword filter
				if ($search) {
					$where[] = 'LOWER( name_complete) LIKE '.$db->Quote( '%'.$db->getEscaped( $search, true ).'%', false );
				}
				switch($filter_state_sex) {
					case "m":
						$where[] = "p.sex = 'm'";
					break;
					case "f":
						$where[] = "p.sex = 'f'";
					break;
					default:
					case -1:
					break;
				}

				if ($filter_surname_firstchar) {
					$where[] = "LOWER(LEFT(p.surname, 1)) = ".$db->Quote($filter_surname_firstchar, FALSE);
				}
				
				switch($filter_state_member) {
					case 1:
					case 0:
						$t = ClubmanagementModelMembers::getByMemberState($filter_state_member);
						if ($t) {					
							$where[] = "m.people_id IN (".implode(",", $t).")";
						}
					break;
					default:
					case -1:
					break;
				}

			break;
		}
		$where = (count($where) ? ' WHERE '.implode(' AND ', $where) : '');

		if (JRequest::getVar('task')=="add") {
			$p = new stdClass;
			$p->people_id = NULL;
			$p->sex = "m";
			$p->name = NULL;
			$p->surname = NULL;
			$p->birthday = NULL;
			$p->address = NULL;
			$p->zipcode = NULL;
			$p->city = NULL;
			$p->country = NULL;
			$p->joomlauser = NULL;
			$p->name_complete = NULL;
			$p->age = NULL;
			$p->current_member = NULL;
			$p->passportPhotograph = NULL;
			$p->params = NULL;
			$this->_data = array($p);
		} else {
#		} elseif (JRequest::getVar('task')=="showall") {
			$order = ' ORDER BY '. $filter_order .' '. $filter_order_Dir .'';
//unset($this->_data);
			$order = "";
			//$where = "";
			if (empty( $this->_data)) {
				$query = " 
					SELECT 
						p.people_id, 
						p.sex, 
						p.name, 
						p.surname, 
						p.birthday, 
						p.address, 
						p.zipcode, 
						p.city, 
						p.country, 
						p.passportPhotograph, 
						p.joomlauser, 
						p.params,
						CONCAT(p.surname, ', ', p.name) AS name_complete, 
						(YEAR(CURRENT_DATE) - YEAR(p.birthday)) - (RIGHT(CURRENT_DATE,5) < RIGHT(p.birthday,5)) AS age
					FROM #__clubmanagement_people AS p
					LEFT JOIN #__clubmanagement_membership AS m ON p.people_id = m.people_id
					".$where ."
					GROUP BY p.people_id
					".$order."
					";

				$db->setQuery($query);
				$this->setState('total', count($db->loadObjectlist()));
				$db->setQuery($query, $this->getState('limitstart'), $this->getState('limit'));
				$this->_data = $db->loadObjectlist();
//echo "<hr/>";
//echo $db->getQuery();
//echo $query;
//echo "<hr/>";
//var_dump($db->loadObjectlist('gna'));
			}
		}
		// Create the pagination object
		jimport('joomla.html.pagination');
		$this->_page = new JPagination($this->getState('total'), $this->getState('limitstart'), $this->getState('limit'));
		return $this->_data;
	}

	/**
	 * Method to store a record
	 *
	 * @access	public
	 * @return	boolean	True on success
	 */
	function store()
	{
		$db		=& JFactory::getDBO();
		$row =& $this->getTable();
echo "<h1>STORE</h1>";
		$data = JRequest::get( 'post' );
print_r($data);
		if (empty($data['birthday'])) {
			$data['birthday'] = NULL;
		}
//$data['surname']='DARR-'.date('Y-m-d');

		$r = new JRegistry('params');
		$r->loadArray($data['params']);
		$data['params'] = $r->toString();
		unset($r);

		// Bind the form fields to the hello table
		if (!$row->bind($data)) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}
		// Make sure the hello record is valid
		if (!$row->check()) {
			$this->setError($db	->getErrorMsg());
			return false;
		}
		// Store the web link table to the database
		//$tmp = $row->store(TRUE);
		$tmp = $row->store();
		if (!$tmp) {
			//$this->setError( $row->getErrorMsg() );
			return false;
		}
echo "HHHH";
		ChangelogHelper::log($db->getQuery(), $tmp);
//die();
		return true;
	}

	/**
	 * Method to delete record(s)
	 *
	 * @access	public
	 * @return	boolean	True on success
	 */
	function delete()
	{
		$cids = JRequest::getVar( 'cid', array(0), 'post', 'array' );
		$row =& $this->getTable();

		if (count( $cids ))
		{
			foreach($cids as $cid) {
				$tmp = $row->delete( $cid );
				if (!$tmp) {
					$this->setError( $row->getErrorMsg() );
					return false;
				} 
				ChangelogHelper::log(JFactory::getDBO()->getQuery(), $tmp);
			}						
			ClubmanagementModelMembers::delete($cids);
			ClubmanagementModelContacts::delete($cids);
			ClubmanagementModelPositions::delete('people_id', $cids);
			ClubmanagementModelTournaments::delete('people', $cids);
		}
		return true;
	}
	function getPagination()
	{
		if (is_null($this->_list) || is_null($this->_page)) {
			$this->getLists();
		}
		return $this->_page;
	}
	
	public static function getPersonalData($id=NULL) {
		$db		=& JFactory::getDBO();
		if(!is_null($id)) {
			$where = "WHERE p.people_id = '".intval($id)."'";
		} else {
			$where = "";
		}
		$query = "
			SELECT 
				p.people_id,
				p.sex, 
				p.name, 
				p.surname, 
				p.birthday, 
			CONCAT(p.surname, ', ', p.name) AS name_complete 
			FROM #__clubmanagement_people AS p
			".$where."";
		$db->setQuery($query);
//echo $db->getQuery();
		if(!is_null($id)) {
			return $db->loadObject();
		} else {
			return $db->loadObjectlist();
		}


	}

	public function getDataPreset() {
		$this->setId(NULL);
		$this->setState('limitstart', NULL);
		$this->setState('limit', NULL);
		$return = $this->getData();
		return $return;
	}
	
}
?>
