<?php
/**
*	@author MDY
*	@package Joomla.Component.Clubmanagement
*	@version 1.0
**/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

jimport( 'joomla.application.component.model' );

class ClubmanagementModelPositions extends JModel
{
	private $_data;
	private $_id;

	function __construct()
	{
#		global $mainframe;
		$mainframe = JFactory::getApplication();
		parent::__construct();

		$tmp = JRequest::getVar('cid',  NULL);
		$this->setId((int)$tmp[0]);

		// Get pagination request variables
		$limit = $mainframe->getUserStateFromRequest('global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 10);
		$limitstart = $mainframe->getUserStateFromRequest($option.'.limitstart', 'limitstart', 0, 0);

		// In case limit has been changed, adjust it
		$limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);

		$this->setState('limit', $limit);
		$this->setState('limitstart', $limitstart);
		$this->getLists();
	}

	function setId($id)
	{
		// Set id and wipe data
		$this->_id		= $id;
		$this->_data	= null;
	}

	/**
	 * @return array Array of objects containing the data from the database
	 */
	function getPersonalData($pid=NULL)
	{
		$db		=& $this->getDBO();
		$where = array();
		switch(JRequest::getVar('task')) {
			case "add":
			break;
			case "edit":
				#$where[] = "pp.position_id = ".$this->_id;
			break;
			default:
			break;
		}
		if (is_array($pid)) {
			JArrayHelper::toInteger($pid);
			$where[] = "p.people_id IN (".implode(",", $pid).")";
		} else if (is_null($pid)) {
			
		} else {
			$where[] = "p.people_id = '".intval($pid)."'";
		}


#print_r($this->_list);
		#$date = '2029-10-1';
		$date = strtotime($this->_list["filter_byDate"]);
		if (!empty($this->_list['filter_byDate']) && $date!==FALSE) {
			$date = date("Y-m-d", $date);
			$where[] = "(position_from <= '".$date."' OR position_from IS NULL) AND (position_until>='".$date."' OR position_until IS NULL)";
		}
		$where[] = "c.section = 'com_clubmanagementPositions'";
		

		if ($this->_list['filter_positions']>0) {
			$where[] = "pp.position_id = '".intval($this->_list['filter_positions'])."'";
		}
		if ($this->_list['filter_state_sex']==='f' || $this->_list['filter_state_sex']==='m') {
			$where[] = "p.sex = '".$this->_list['filter_state_sex']."'";
		}



		$where = (count($where) ? ' WHERE '.implode(' AND ', $where) : '');
		if (is_null($pid)) {
			if (empty( $this->_data ))
			{
				$query = "
			SELECT 
				p.people_id, p.name, p.surname, p.sex,
				COUNT(pp.peoplepositions_id) AS sum,
				GROUP_CONCAT(c.title SEPARATOR ', ') AS positions
			FROM #__clubmanagement_peoplepositions AS pp
			INNER JOIN #__categories AS c ON pp.position_id = c.id
			INNER JOIN #__clubmanagement_people AS p ON pp.people_id = p.people_id
			".$where."
			GROUP BY pp.people_id, p.name, p.surname, p.sex
			ORDER BY p.surname, p.name ASC
					";
			}
		} else {
			echo "<h3>Sortierung noch einbauen</h3>";
			$query = "
			SELECT 
				pp.peoplepositions_id as id, pp.people_id, pp.position_id, pp.position_from, pp.position_until, pp.description,
				p.name, p.surname, p.sex,
				c.title as position
			FROM #__clubmanagement_peoplepositions AS pp
			INNER JOIN #__categories AS c ON pp.position_id = c.id
			INNER JOIN #__clubmanagement_people AS p ON pp.people_id = p.people_id
			".$where."
			ORDER BY p.surname, p.name, c.title
				";
		}

		$db->setQuery($query);
		$this->setState('total', count($db->loadObjectlist()));
		$db->setQuery($query, $this->getState('limitstart'), $this->getState('limit'));
		$this->_data = $db->loadObjectlist();
#echo "<pre>";
#print_r($db->loadObjectlist());
#echo $this->getState('limit');
#echo "</pre>";
#echo $db->getQuery();
#print_r($this->_data);
		return $this->_data;
	}

	function getPagination()
	{
		$db		=& $this->getDBO();

		$query = "SELECT * FROM #__clubmanagement_peoplepositions";
		$db->setQuery($query);
		$total = $db->loadRow ();
		$total = $db->getAffectedRows ();

		// Create the pagination object
		jimport('joomla.html.pagination');
		$this->_page = new JPagination($total, $this->getState('limitstart'), $this->getState('limit'));
		$db->setQuery($query, $this->_page->limitstart, $this->_page->limit);


		if (is_null($this->_list) || is_null($this->_page)) {
			$this->getLists();
		}
		return $this->_page;
	}

	function &getLists() {
#		global $mainframe;
#		$mainframe = JFactory::getApplication();
		$context= 'com_clubmanagement.positions.list.';
		$lists = array();

		$filter	= null;

		$filter_order= JFactory::getApplication()->getUserStateFromRequest( $context.'filter_order', 'filter_order');
		if (!$filter_order) {
			$filter_order = 'surname';
		}
		$filter_order_Dir= JFactory::getApplication()->getUserStateFromRequest($context.'filter_order_Dir', 'filter_order_Dir');
		$filter_positions = JFactory::getApplication()->getUserStateFromRequest($context.'filter_positions', 'filter_positions', 0);
		$filter_state_sex = JFactory::getApplication()->getUserStateFromRequest($context.'filter_state_sex', 'filter_state_sex', 0);
		$filter_byDate = JFactory::getApplication()->getUserStateFromRequest($context.'filter_byDate', 'filter_byDate', NULL);

		// table ordering
		$lists['order_Dir']	= $filter_order_Dir;
		$lists['order']		= $filter_order;

		//	Filter
		$lists["filter_positions"] = $filter_positions;
		$lists["filter_state_sex"] = $filter_state_sex;
		$lists["filter_byDate"] = $filter_byDate;
#print_r($lists);
		$this->_list = $lists;
		return $lists;
	}

	function store()
	{
		$row =& $this->getTable('Peoplepositions');
		$data = JRequest::get( 'post' );
		//	delete first
		if (is_array($data['deletePosition']) && count($data['deletePosition'])>0) {
			$this->delete('peoplepositions_id', $data['deletePosition']);
		} else {
			$data['deletePosition'] = array();
		}
		//	get update ids
		if(is_array($data['changePosition']) && count($data['changePosition'])>0) {
			$update = array_values(array_diff($data['changePosition'], $data['deletePosition']));
		}

		$return = TRUE;
		for($i=0; $i<count($update); $i++) {
			$m = array();
			$m['peoplepositions_id'] 	= $update[$i];
			$m['people_id'] 			= $data['people_id'];
			$m['position_from'] 		= ((empty($data['position_from_'.$update[$i]]) || ($data['position_from_'.$update[$i]]=='0000-00-00')) ? NULL : $data['position_from_'.$update[$i]]);
			$m['position_until'] 		= ((empty($data['position_until_'.$update[$i]]) || ($data['position_until_'.$update[$i]]=='0000-00-00')) ? NULL : $data['position_until_'.$update[$i]]);
			$m['position_id'] 			= $data['position_'.$update[$i]];
			$m['description'] 			= $data['position_description_'.$update[$i]];

			// Bind the form fields to the hello table
			if (!$row->bind($m)) {
				$this->setError($this->_db->getErrorMsg());
				$return = FALSE;
			}

			// Make sure the hello record is valid
			if (!$row->check()) {
				$this->setError($this->_db->getErrorMsg());
				$return = FALSE;
			}
			// Store the web link table to the database
			$tmp = $row->store(TRUE);
			if (!$tmp) {
				$this->setError( $row->getErrorMsg() );
				$return = FALSE;
			}
			ChangelogHelper::log(JFactory::getDBO()->getQuery(), $tmp);
		}

		if (!empty($data['position_from_0']) && !empty($data['position_0'])) {
			$m = array();
			$m['people_id'] 		= $data['people_id'];
			$m['position_from'] 	= $data['position_from_0'];
			$m['position_until'] 	= ((empty($data['position_until_0']) || ($data['position_until_0']=='0000-00-00')) ? NULL : $data['position_until_0']);
			$m['position_id'] 		= $data['position_0'];
			$m['description'] 		= $data['position_description_0'];

			// Bind the form fields to the hello table
			if (!$row->bind($m)) {
				$this->setError($this->_db->getErrorMsg());
				$return = FALSE;
			}

			// Make sure the hello record is valid
			if (!$row->check()) {
				$this->setError($this->_db->getErrorMsg());
				$return = FALSE;
			}
			// Store the web link table to the database
			$tmp = $row->store(TRUE);
			if (!$tmp) {
				$this->setError( $row->getErrorMsg() );
				$return = FALSE;
			}
			ChangelogHelper::log(JFactory::getDBO()->getQuery(), $tmp);
		}
		return $return;
	}

	function delete($type, $cids = NULL) {
		$db		=& $this->getDBO();
		if (is_array($cids) && count($cids)>0) {
			
		} else {
			$cids = JRequest::getVar( 'cid', array(0), 'post', 'array' );
			JArrayHelper::toInteger($cids);
		}
		$cids = implode(",", $cids);

		switch($type) {
			case "people_id":
				$query = "DELETE FROM #__clubmanagement_peoplepositions WHERE people_id IN (".$cids.")";
			break;
			case "peoplepositions_id":
			default:
				$query = "DELETE FROM #__clubmanagement_peoplepositions WHERE peoplepositions_id IN (".$cids.")";
			break;
		}


		$db->setQuery($query);
echo $db->getQuery();
#die();
		$return = $db->query();
		ChangelogHelper::log($query, $return);
		return $return;
	}

}
