DROP TABLE IF EXISTS `#__clubmanagement_administration`;
CREATE TABLE IF NOT EXISTS `#__clubmanagement_administration` (
	`administrator_id` int(11) NOT NULL AUTO_INCREMENT,
	`joomlauser_id` int(11) NOT NULL,
	`params` text NOT NULL,
	PRIMARY KEY (`administrator_id`),
	UNIQUE KEY `joomlauser_id` (`joomlauser_id`)
);

DROP TABLE IF EXISTS `#__clubmanagement_agegroups`;
CREATE TABLE `#__clubmanagement_agegroups` (
	`agegroup_id` INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
	`description` TEXT NULL,
	`icon` VARCHAR(50) NULL,
	`age_from` INTEGER UNSIGNED NULL,
	`age_until` INTEGER UNSIGNED NULL,
	PRIMARY KEY(agegroup_id)
);
DROP TABLE IF EXISTS `#__clubmanagement_contacts`;
CREATE TABLE `#__clubmanagement_contacts` (
	`contacts_id` INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
	`people_id` INTEGER UNSIGNED NOT NULL,
	`contacttype_id` INTEGER UNSIGNED NOT NULL,
	`contactpriority` INTEGER(1) UNSIGNED NOT NULL,
	`contactdata` VARCHAR(100) NULL,
	PRIMARY KEY(contacts_id)
);

DROP TABLE IF EXISTS `#__clubmanagement_memberaccount`;
CREATE TABLE `#__clubmanagement_memberaccount` (
	`transaction_id` INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
	`people_id` INTEGER UNSIGNED NOT NULL,
	`date` DATE NULL,
	`transaction` DECIMAL(5,2) NULL,
	`description` VARCHAR(100) NULL,
	PRIMARY KEY(transaction_id)
);

DROP TABLE IF EXISTS `#__clubmanagement_membership`;
CREATE TABLE `#__clubmanagement_membership` (
	`membership_id` INTEGER UNSIGNED NOT NULL AUTO_INCREMENT,
	`people_id` INTEGER NOT NULL,
	`member_from` DATE NULL,
	`member_until` DATE NULL,
	`section_id` INTEGER UNSIGNED NOT NULL,
	`passport` VARCHAR(20) NULL,
	PRIMARY KEY(membership_id)
);

DROP TABLE IF EXISTS `#__clubmanagement_people`;
CREATE TABLE IF NOT EXISTS `#__clubmanagement_people` (
  `people_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sex` enum('m','f') DEFAULT 'm',
  `name` varchar(50) DEFAULT NULL,
  `surname` varchar(50) DEFAULT NULL,
  `birthday` date DEFAULT NULL,
  `address` varchar(100) DEFAULT NULL,
  `zipcode` varchar(10) DEFAULT NULL,
  `city` varchar(50) DEFAULT NULL,
  `country` varchar(3) DEFAULT NULL,
  `joomlauser` int(10) DEFAULT NULL,
  `bankaccountnumber` varchar(15) DEFAULT NULL,
  `bankname` varchar(50) DEFAULT NULL,
  `bankcodenumber` varchar(15) DEFAULT NULL,
  `passportPhotograph` varchar(100) DEFAULT NULL,
  `params` text NOT NULL,
  PRIMARY KEY (`people_id`)
) DEFAULT CHARSET=utf8 ;

DROP TABLE IF EXISTS `#__clubmanagement_peoplepositions`;
CREATE TABLE IF NOT EXISTS `#__clubmanagement_peoplepositions` (
	`peoplepositions_id` int(11) NOT NULL AUTO_INCREMENT,
	`people_id` int(10) unsigned NOT NULL,
	`position_id` int(10) unsigned NOT NULL,
	`position_from` date DEFAULT NULL,
	`position_until` date DEFAULT NULL,
	`description` text NOT NULL,
	PRIMARY KEY (`peoplepositions_id`)
);
--
-- Tabellenstruktur für Tabelle `jos_clubmanagement_changelog`
--

DROP TABLE IF EXISTS `#__clubmanagement_changelog`;
CREATE TABLE IF NOT EXISTS `#__clubmanagement_changelog` (
	`query` text NOT NULL,
	`success` tinyint(1) DEFAULT NULL,
	`changed_by_joomlauser` int(11) DEFAULT NULL,
	`changed_by_username` varchar(20) NOT NULL,
	`changed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
);

--
-- Tabellenstruktur für Tabelle `jos_clubmanagement_tournamentpositions`
--

DROP TABLE IF EXISTS `#__clubmanagement_tournamentpositions`;
CREATE TABLE IF NOT EXISTS `#__clubmanagement_tournamentpositions` (
  `tournamentposition_id` int(11) NOT NULL AUTO_INCREMENT,
  `tournament_id` int(11) NOT NULL,
  `people_id` int(11) NOT NULL,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`tournamentposition_id`),
  UNIQUE KEY `positions` (`tournament_id`,`people_id`,`position`),
  UNIQUE KEY `singleposition` (`tournament_id`,`people_id`)
) DEFAULT CHARSET=utf8 ;
