<?php

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();
jimport('joomla.application.component.model');

class ClubmanagementModelPeople extends JModel
{
	private $pid = FALSE;
	public function __construct()
	{
		$db		=& JFactory::getDBO();
		$this->pid = (int)JRequest::getVar('cid', NULL);
		parent::__construct();


	}

	public function getData($pid = NULL) {
		$db		=& JFactory::getDBO();
		$this->pid = $pid;
		// Load the data
		if (empty( $this->_data )) {
			$query = " 
				SELECT 
					p.people_id, 
					p.sex, 
					p.name, 
					p.surname, 
					p.birthday, 
					p.address, 
					p.zipcode, 
					p.city, 
					p.country, 
					p.joomlauser, 
					p.passportPhotograph, 
					p.params,
					IF (p.bankaccountnumber='' && p.bankname = '' && p.bankcodenumber = '', 0, IF(p.bankaccountnumber!='' && p.bankname != '' && p.bankcodenumber != '', 1, -1)) AS bankaccount,
					CONCAT(p.surname, ', ', p.name) AS name_complete, 
					(YEAR(CURRENT_DATE) - YEAR(p.birthday)) - (RIGHT(CURRENT_DATE,5) < RIGHT(p.birthday,5)) AS age
				FROM #__clubmanagement_people AS p
				WHERE p.people_id = ".$this->pid;
			$db->setQuery( $query, 0, 1);
//echo "<p>".$db->getQuery()."</p>";
			$this->_data = $db->loadObjectList();
		}
		return $this->_data;
	
	}
	
	function getMembershipData() {
		$db		=& JFactory::getDBO();
			$query = " 
				SELECT 
					p.member_from, 
					p.member_until, 
					p.section_id, 
					p.passport,
					c.title AS section
				FROM #__clubmanagement_membership AS p
				INNER JOIN #__categories AS c ON c.id = p.section_id
				WHERE p.people_id = ".$this->pid."
				ORDER BY p.member_from";
			$db->setQuery( $query);
  		$tmp = $db->loadObjectList();
		return $tmp;
	}
	
	function getSpecialPositions() {
		$db	= &$this->getDBO();
			$query = " 
				SELECT 
					p.position_from, 
					p.position_until, 
					p.description AS peopledescription, 
					c.image,
					c.title AS positiondescription
				FROM #__clubmanagement_peoplepositions AS p
				INNER JOIN #__categories AS c ON p.position_id = c.id
				WHERE p.people_id = ".$this->pid."
				ORDER BY p.position_from DESC";
			$db->setQuery( $query);
		$tmp = $db->loadObjectList();
		return $tmp;
	}
	
	function getContacts() {
		$db	= &$this->getDBO();
			$query = " 
				SELECT 
					c.contactdata,
					j.title,
					j.image
				FROM #__clubmanagement_contacts AS c
				INNER JOIN #__categories AS j ON c.contacttype_id = j.id
				WHERE c.people_id = ".$this->pid."
				ORDER BY c.contactpriority ASC";
			$db->setQuery( $query);
		$tmp = $db->loadObjectList();
//echo $db->getQuery();
		return $tmp;
	}

	public static function getPersonalData($id) {
		$db		=& JFactory::getDBO();
		$query = "
			SELECT 
				p.people_id,
				p.sex, 
				p.name, 
				p.surname, 
				CONCAT(p.surname, ', ', p.name) AS name_complete 
			FROM #__clubmanagement_people AS p
			WHERE p.people_id = '".intval($id)."'";
		$db->setQuery($query);
//echo $db->getQuery();
		return $db->loadObject();
	}

	function getTournaments() {
		$db	= &$this->getDBO();
			$query = " 
				SELECT 
					tp.tournament_id,
					tp.position
				FROM #__clubmanagement_tournamentpositions AS tp
				WHERE tp.people_id = ".$this->pid;
			$db->setQuery( $query);
		$tmp = $db->loadObjectList();
		require_once(JPATH_ADMINISTRATOR .DS. 'components' .DS. 'com_clubmanagement' .DS. 'models' . DS . 'tournaments.php');

		$model = & JModel::getInstance('tournaments','ClubmanagementModel');
		for($i=0; $i<count($tmp); $i++) {
			$t =$model->getData($tmp[$i]->tournament_id);
			$r = (object) array_merge((array) $t[0], (array) $tmp[$i]);
//echo "<pre>";
//print_r($r);
//print_r($t);
//print_r($tmp[$i]->tournament_id);
//echo "</pre>";
			$tmp[$i] = $r;
		}
//echo $db->getQuery();
		return $tmp;
	}

}
?>
