<?php
if (count($this->tournaments)>0 && $this->params->get('show_tournaments')) {
?>

	<table id="tournaments">
		<caption><?php echo JText::_('COM_CLUBMANAGEMENT_TOURNAMENTS');?></caption>
		<thead>
		<tr>
			<th><?php echo JText::_('COM_CLUBMANAGEMENT_DATE');?></th>
			<th><?php echo JText::_('COM_CLUBMANAGEMENT_TOURNAMENTS');?></th>
			<th><?php echo JText::_('COM_CLUBMANAGEMENT_RANKING_POSITION');?></th>
		</tr>
		</thead>
		<tbody>
<?php
for($i=0; $i<count($this->tournaments);$i++) {
	$t = $this->tournaments[$i];
	$d2 = (is_null($t->starttime) ? "" : JFactory::getDate(strtotime($t->starttime))->toFormat(JText::_('%Y-%M-%D')));
	$title = $t->title;
	if (!empty($t->category)) {$title .= " - ".$t->category;}
	if (!empty($t->host)) {$title .= " - ".$t->host;}
	if (!empty($t->place)) {$title .= " - ".$t->place;}
	$row = (($i%2==0) ? "even" : "odd");
?>
		<tr class="<?php echo $row;?>">
			<td><?php echo $d2; ?></td>
			<td><?php echo JHTML::link($t->url, $t->title, 'title="'.$title.'"');?></td>
			<td><?php echo LegendHelper::renderMultiIcon("medal", $t->position);?><?php echo $t->position;?>. <?php echo JText::_('COM_CLUBMANAGEMENT_RANKING_POSITION');?></td>
		</tr>
<?php
}
?>
		</tbody>
	</table>
<?php
}
?>