/**
*	Sortiert den angegebenen Bereich der Tabelle.
*	Eine Zeile oder Spalte wird von dem bisherigen Platz auf den neuen verschoben.
*	@param id String Eindeutiger Bezeichner der Tabelle
*	@param section thead|tbody|tfoot Bezeichnung des zu sortierenden Bereiches
*	@param axis row|col Spalten oder Zeilensortierung
*	@param from integer Bisheriger Index der Zeile/Spalte (bei 0 beginnend)
*	@param to integer Neuer Index der Zeile/Spalte (bei 0 beginnend)
*/
function reorderTable(id, section, axis, from, to) {
	//	default
	c = document.getElementById(id).getElementsByTagName(section)[0];
	r = c.rows;
	r2 = new Array();
	var maxRows;
	if (axis=='row') {
		maxRows = r.length;
		if (from < 0 || to < 0 || to > maxRows-1) {
			return false;
		} else {
			for(i = 0; i < maxRows; i++) {
				r2[i] = r[i];
			}
			tmp = r2[to];
			r2[to] = r2[from];
			r2[from] = tmp;

			for(i=0; i < maxRows; i++) {
				c.appendChild(r2[i]);
			}
		}

	} else {
		//	später
		return false;
	}
}

function resetPriority() {
	c = document.getElementsByName("contactpriority[]");
	for(i = 0; i < c.length; i++) {
		c[i].value = c[i].parentNode.parentNode.parentNode.sectionRowIndex+1;
	}
	return false;
}

function createContactRow(table, section) {
	var x=document.getElementById(table).getElementsByTagName(section)[0];
	var l = x.rows.length;
	var r = x.insertRow(l);

	r.className = 'row'+l%2;
	var t1=r.insertCell(0);
	var t2=r.insertCell(1);
	var t3=r.insertCell(2);
	var t4=r.insertCell(3);

	c1 = document.getElementById('newcontacttype');
	c1d = c1.cloneNode(true);
	c1d.setAttribute("id", 'contacttype_'+l);
	c1d.setAttribute("name", 'contacttype[]');
	c1d.value = c1.value;
	t1.appendChild(c1d);
	c1.value = 0;

	c2 = document.getElementById('newcontactdata');
	c2d = c2.cloneNode(true);
	c2d.removeAttribute("id");
	c2d.setAttribute("name", 'contactdata[]');
	t2.appendChild(c2d);
	c2.value = '';

	h2=document.createElement("input");
	h2.setAttribute("type", "hidden");
	h2.setAttribute("name", 'contacts_id[]');
	t2.appendChild(h2);


	o3 = document.getElementById('newcontactorder');
	c3d = o3.cloneNode(true);
	c3d.setAttribute("style", "text-align: center; ");
	c3d.getElementsByTagName("a")[0].setAttribute("onclick", "reorderUp(this); return false;");
	c3d.getElementsByTagName("a")[1].setAttribute("onclick", "reorderDown(this); return false;");
	i3 = c3d.getElementsByTagName("input")[0];
	i3.removeAttribute("disabled");
	i3.setAttribute("name", "contactpriority[]");
	i3.value = l+1;
	c3d.removeAttribute("id");
	c3d.setAttribute("name", 'contactdata[]');
	t3.appendChild(c3d);

	a4 = document.getElementById('newcontactadd');
	a4d = a4.cloneNode(true);
	a4d.setAttribute("onclick", "this.parentNode.parentNode.parentNode.deleteRow(this.parentNode.parentNode.sectionRowIndex); return false;");
	a4d.removeAttribute("id");
	a4d.getElementsByTagName("img")[0].setAttribute("src", a4d.getElementsByTagName("img")[0].getAttribute("src").replace('add.png', 'delete.png'));
	a4d.setAttribute("style", "display: block; text-align:center;");

	t4.appendChild(a4d);
}

function deleteTableRow(obj) {
	obj.parentNode.parentNode.parentNode.deleteRow(obj.parentNode.parentNode.sectionRowIndex);
	return false;	
}

function reorderUp(obj) {
	reorderTable('contactdatatable', 'tbody', 'row', obj.parentNode.parentNode.parentNode.sectionRowIndex, obj.parentNode.parentNode.parentNode.sectionRowIndex-1); 
	resetPriority();
	return false;	
}

function reorderDown(obj) {
	reorderTable('contactdatatable', 'tbody', 'row', obj.parentNode.parentNode.parentNode.sectionRowIndex, obj.parentNode.parentNode.parentNode.sectionRowIndex+1);
	resetPriority(); 
	return false;
}
