<?php
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

class ClubmanagementControllerAdministration extends ClubmanagementController
{
	/**
	 * constructor (registers additional tasks to methods)
	 * @return void
	 */
	function __construct()
	{
		parent::__construct();

		// Register Extra tasks
		$this->registerTask( 'add', 'edit' );
		$this->registerTask( 'unpublish', 'publish');
		$this->registerTask( 'cancel', 'cancel');
		$this->registerTask( 'save', 'apply');
		$model4 = $this->getModel('administration');
		$view  = $this->getView('administration', 'html');
		$view->setModel($model4);
	}

	function edit()
	{
		JRequest::setVar( 'view', 'administration' );
		JRequest::setVar( 'layout', 'form'  );
		JRequest::setVar('hidemainmenu', 1);

		parent::display();
	}

	
	function save() {
		$model = $this->getModel('administration');
#echo "HHH";
#die();
		if ($model->store($post)) {
			$msg = JText::_( 'administration Saved!' );
		} else {
			$msg = JText::_( 'Error Saving Clubmanagement' );
		}
#echo $msg;
		$link = 'index.php?option=com_clubmanagement&view=administration';
		$this->setRedirect($link, $msg);
	}
	
	/**
	 * remove record(s)
	 * @return void
	 */
	function remove()
	{
		$model = $this->getModel('administration');
		if(!$model->delete()) {
			$msg = JText::_( 'Error: One or more Administrators could not be Deleted' );
		} else {
			$msg = JText::_( 'Administrator(s) deleted' );
		}
		$this->setRedirect( 'index.php?option=com_clubmanagement&view=administration', $msg );
	}


	/**
	 * cancel editing a record
	 * @return void
	 */
	function cancel()
	{
		$msg = JText::_( 'Operation Cancelled' );
		$this->setRedirect( 'index.php?option=com_clubmanagement&view=administration', $msg );
	}
	
}
?>
