<?php

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

class ClubmanagementControllerMaintenance extends ClubmanagementController
{
	private $_uploadFileErrors;
	
	function __construct()
	{
		//JRequest::getCmd('task');
		$this->_uploadFileErrors = array();
		parent::__construct();
	}
	
	private static function getCategoryPrefix() {
		return "Clubmanagement";
	}
	
	private static function getComponentName() {
		return JRequest::getVar('option');
		//return "com_clubmanagement";
	}
	
	private static function getAffectedCategoryExtensions() {
		$prefix = self::getCategoryPrefix();
		return array(
			$prefix.'.teammemberpositions',
			$prefix.'.leagues',
			$prefix.'.positions',
			$prefix.'.contacttypes',
			$prefix.'.sections',
			$prefix.'.seasons'
		);
	}
	
	private static function getOrderedExportTables() {
		return array(
			'changelog',
			'agegroups',
			'people',
			'peoplepositions',
			'contacts',
			'member',
			'teams',
			'teammember',
			'tournamentpositions'
		);
	}

	/************************** methods *********************************/

	public function clearJunk() {
		self::clearExisting();
	}
	

	public function export() {
		$data = self::getExportData();
		header("Content-type: text/plain");
		header("Content-Disposition: attachment;filename=clubmanagement-export.json");
		echo $output = json_encode($data);
		die();
	}
	
	public function exportScreen() {
		parent::display();
		$data = self::getExportData();
		echo "<h1>Datenexport</h1>";
		foreach($data as $k => $v) {
			echo "<h2>".$k."</h2>";
			foreach($v as $k2 => $v2) {
				echo "<h3>".$k2."</h3>";
				echo "<p>".count($v2)."</p>";
				//echo "<p>".$v2."</p>";
			}
		}
	}
	
	private static function getExportData() {
		jimport('joomla.version');
		$data = array('metaData'=>array(), 'categories'=>array(), 'tables'=>array());
		$data['metaData']	=	self::getExportMetaData();
		$data['categories']	=	self::exportCategories();
		$data['tables']		=	self::exportData();
		return $data;	
	}
	
	/**
	*	@uses JVersion
	*/
	private static function getExportMetaData() {
		$version = new JVersion;
		return array(
			'joomlaVersion'		=>	$version->getShortVersion(),
			'componentName'		=>	'Clubmanagement',
			'idTranslations'	=>	array(),
		);
	}
	
	/**
	*	@uses	CategoryHelper
	*/
	private static function exportCategories() {
		$exportKeys = array("id","parent_id","level","extension","title","alias","description","published","access","params","metadesc","metakey","metadata","hits","language");
		$idExport = self::getAffectedCategoryExtensions();
		$data = array();
		for($i=0; $i<count($idExport); $i++) {
			$c = CategoryHelper::getFlat($idExport[$i], $exportKeys);
			$data[$idExport[$i]] = $c;
		}
		return $data;
	}
	
	/**
	*	@uses JFolder::files
	*	@uses JTable::getInstance
	*	@uses JTable::addIncludePath
	*/
	private static function exportData() {
		JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables'.DS);
		$tables = self::getOrderedExportTables();
		for($i=0; $i<count($tables); $i++) {
			$table = JTable::getInstance($tables[$i], 'Table');
			if($table) {
				$tmp = $table->loadAll();
				$data[$tables[$i]] = $tmp;
			}
		}
		return $data;
	}

	/**
	*	@uses JRequest::setVar
	*	@uses JRequest::getVar
	*	@uses JTable::addIncludePath
	*	
	*/
	public function import() {
		JRequest::setVar( 'view', 'maintenance' );
		JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.DS.'tables'.DS);
		switch (JRequest::getVar("subtask")) {
			case "showImportData":
//echo "<pre>";
				//$data = JRequest::getVar('importFileTmp');
				//$data = str_replace("'", "\"", $data);
				$data = JRequest::getVar('importData');
				$data = html_entity_decode($data);
				$data = substr($data, 0, -1);
				$data = json_decode($data, TRUE);
//echo "<hr/>";
//echo "</pre>";

				$d2 = $data;
				self::clearExisting($data);
				self::importCategories($data);
				self::importData($data);
				JRequest::setVar( 'importData', $d2);
				JRequest::setVar( 'layout', 'showImportData');

echo "<pre>";
print_r($data['metaData']['idTranslations']);
echo "</pre>";


				//$this->setRedirect( 'index.php?option=com_clubmanagement&view=maintenance&task=import&subtask=error', $this->_uploadFileErrors );
			break;
			case "upload":
				if((isset($_FILES['importFile']['name']) && $_FILES['importFile']['name']!='')) {
					$file = self::checkUploadedFile();
					if($file) {
						$data = self::getImportData($file);
						JRequest::setVar( 'importData', $data);
						JRequest::setVar( 'layout', 'showImportData');		
					} else {
						$this->_uploadFileErrors = implode("<br/>\n", $this->_uploadFileErrors);
						$this->setRedirect( 'index.php?option=com_clubmanagement&view=maintenance&task=import', $this->_uploadFileErrors );
					}
				} else {
					JRequest::setVar( 'layout', 'upload');		
				}
			break;		
			default:
				JRequest::setVar( 'layout', 'upload');		
			break;
		}

		parent::display();
	}
	
	/**
	*	@uses JFactory::getDBO
	*	@uses JTable::getInstance
	*/
	private static function clearExisting() {
		$data 	= self::getExportData();
		$db		= JFactory::getDBO();

/*
		$name	= self::getComponentName();
		$query	= "DELETE FROM #__categories WHERE extension LIKE '".$name."%'";
			$db->setQuery($query);
			$return = $db->query();

		$query	= "DELETE FROM #__assets WHERE name LIKE '".$name."%'";
			$db->setQuery($query);
			$return = $db->query();
*/		


/*
*/
		//	categories
		$cats = array();
		foreach($data['categories'] as $array) {
			$cats = array_merge($cats, $array);
		}
		self::deleteCategories(array_reverse($cats));

		//	data
		$tables = array_keys($data['tables']);
		foreach($tables as $tname) {
			$table = JTable::getInstance($tname, 'Table');
			$query = "TRUNCATE TABLE ".$table->getTableName();
			$db->setQuery($query);
			$return = $db->query();
		}
/*
*/
	}

	/**
	*	@uses JTable::getInstance
	*/
	private static function deleteCategories($data) {
		foreach($data as $cat) {
			$table = JTable::getInstance('Category', 'JTable');
			$table->load($cat['id']);
			$tmp = $table->delete($table->id);
			//var_dump($tmp);
			if(!$tmp) {
				echo "<h1>nicht löschbar: ".$cat['id']."</h1>";
			} else {
				echo "<h1>löschbar: ".$cat['id']."</h1>";
			}
		}
	}

	/**
	*	@uses jimport
	*/
	private static function importCategories(&$data) {
		jimport( 'joomla.application.categories' );
		$file = JPATH_ADMINISTRATOR.DS.'components'.DS.'com_categories'.DS.'models'.DS.'category.php';
		require_once($file);

		if(!isset($data['metaData']['idTranslations'])) {
			$data['metaData']['idTranslations'] = array();
		}

		foreach($data['categories'] as $key => $array) {
			$data['metaData']['idTranslations'][$key] = array();
			foreach($array as $k => $cat) {
				$prevId = $cat['id'];
				self::addCategory($cat, $data['metaData']['idTranslations'][$key]);
				$data['metaData']['idTranslations'][$key][$prevId] = $cat['id'];
				$array[$k] = $cat;
			}
		}
	}
	
	/**
	*	@uses CategoriesModelCategory
	*/
	private static function addCategory(&$data, $idTranslations) {
		$c = new CategoriesModelCategory;

		if(!isset($data['access']) || (isset($data['access']) && empty($data['access']))) {
			$data['access'] = 1;
		}
		if(isset($data['level']) && isset($data['parent_id']) && $data['level']>1 && $data['parent_id']!='root') {
			//	with parent
			if(isset($idTranslations[$data['parent_id']])) {
				$data['parent_id'] = $idTranslations[$data['parent_id']];
			}
		} else {
			//	add
			$data['parent_id'] = NULL;
		}
		$data['level'] = NULL;
		$data['id'] = NULL;
		$data['alias'] = NULL;
	
		$tmp = $c->save($data);
		$data['id'] = $c->getState($c->getName().'.id');
		
		return TRUE;
	}

	/**
	*	@uses JTable::getInstance
	*	@uses JError::raiseError
	*	@uses JError::raiseWarning
	*/
	private static function importData(&$data) {
		foreach($data['tables'] as $key => $array) {
			$table = JTable::getInstance($key, 'Table');
			if($table) {
				$pk = call_user_func(get_class($table).'::getPrimaryKey');
				foreach($array as $k => $d) {
					self::translateIds($d, $table, $data['metaData']);
					$table->$pk = NULL;
					$oldId	= $d[$pk];
					$d[$pk] = NULL;

//if(isset($d['team_id'])) {
//	print_r($d);
//	echo "<br/>";
//}
					if (!$table->bind($d)) {
						return JError::raiseWarning(500, $table->getError());
					}
					if (!$table->store()) {
						JError::raiseError(500, $table->getError());
					}
					$keyID = $key.".".$pk;
					if(!isset($data['metaData']['idTranslations'][$keyID]) || !is_array($data['metaData']['idTranslations'][$keyID])) {
						$data['metaData']['idTranslations'][$keyID] = array();
					}
					$data['metaData']['idTranslations'][$keyID][$oldId] = $table->$pk;
				}			
			} else {
				echo "keine tabelle: ".$key."<br/>\n";
			}
		}
	}
	
	private static function translateIds(&$obj, $table, $meta) {
		$relations = call_user_func(get_class($table).'::getRelations');
		if(isset($relations['categories']) && is_array($relations['categories']) && count($relations['categories'])>0) {
			foreach($relations['categories'] as $key => $trans) {
				if(isset($obj[$key]) && isset($meta['idTranslations'][$trans[0]][$obj[$key]])) {
					$obj[$key] = $meta['idTranslations'][$trans[0]][$obj[$key]];
				} else {
					//echo "<h4>kein ID Umbau möglich: ".$key." : ".$obj[$key]."</h4>";
					$obj[$key] = NULL;
				}
			}
		}

		if(isset($relations['data']) && is_array($relations['data']) && count($relations['data'])>0) {
			foreach($relations['data'] as $key => $trans) {
				if(isset($obj[$key]) && isset($meta['idTranslations'][$trans[0]][$obj[$key]])) {
					$obj[$key] = $meta['idTranslations'][$trans[0]][$obj[$key]];
				} else {
					//echo "<h4>kein ID Umbau möglich: ".$key." : ".$obj[$key]."</h4>";
					$obj[$key] = NULL;
				}
			}
		}
	}
	
	private static function getImportData($file) {
		$c = file_get_contents($file);
		return json_decode($c, TRUE);
	}
	
	private function checkUploadedFile() {
		$fieldName = 'importFile';
		//any errors the server registered on uploading
		$fileError = $_FILES[$fieldName]['error'];
		if ($fileError > 0) {
			switch ($fileError) {
				case 1:
				$this->_uploadFileErrors[] = JText::_( 'FILE TO LARGE THAN PHP INI ALLOWS' );
				return FALSE;
		 
				case 2:
				$this->_uploadFileErrors[] = JText::_( 'FILE TO LARGE THAN HTML FORM ALLOWS' );
				return FALSE;
		 
				case 3:
				$this->_uploadFileErrors[] = JText::_( 'ERROR PARTIAL UPLOAD' );
				return FALSE;
		 
				case 4:
				$this->_uploadFileErrors[] = JText::_( 'ERROR NO FILE' );
				return FALSE;
			}
		}
		 
		//check for filesize
		$fileSize = $_FILES[$fieldName]['size'];
		if($fileSize > 2000000) {
			$this->_uploadFileErrors[] = JText::_( 'FILE BIGGER THAN 2MB' );
		}
		 
		//check the file extension is ok
		$fileName = $_FILES[$fieldName]['name'];
		$uploadedFileNameParts = explode('.',$fileName);
		$uploadedFileExtension = array_pop($uploadedFileNameParts);
		 
		$extOk = strtolower($uploadedFileExtension)=='json' ? TRUE : FALSE;
		 
		if ($extOk == false) {
			$this->_uploadFileErrors[] = JText::_( 'INVALID EXTENSION' );
			return FALSE;
		}
		return $fileTemp = $_FILES[$fieldName]['tmp_name'];
	}
}
?>