<?php
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

class ClubmanagementControllerMember extends ClubmanagementController
{
	/**
	 * constructor (registers additional tasks to methods)
	 * @return void
	 */
	function __construct()
	{
		parent::__construct();

		// Register Extra tasks
#		JSubMenuHelper::addEntry(JText::_('positionsAdmin'), 'index.php?option=com_clubmanagement&view=positionsAdmin');
		$model4 = $this->getModel('administration');
		$view  = $this->getView('administration', 'html');
		$view->setModel($model4);

		$this->registerTask( 'apply', 'save' );
		$this->registerTask( 'add', 'edit' );

	}
	
	function add2()
	{
		$model1 = $this->getModel ('people');
		$view  = $this->getView('member', 'html');
		$view->setModel($model1, TRUE);
		JRequest::setVar( 'view', 'member' );
		JRequest::setVar( 'layout', 'new'  );
		JRequest::setVar('hidemainmenu', 1);
		parent::display();
	}

	function edit()
	{
		$model1 = $this->getModel ('people');
		$view  = $this->getView('member', 'html');
		$view->setModel($model1, TRUE);
		JRequest::setVar( 'view', 'member' );
		JRequest::setVar( 'layout', 'form'  );
		JRequest::setVar('hidemainmenu', 1);
		parent::display();
	}


	function save()
	{
		$model = $this->getModel('member');
		if ($model->store()) {
		  $msg = JText::_( 'Member Saved!' );
		} else {
		  $msg = JText::_( 'Error Saving Member' );
		}

		switch (JRequest::getCmd( 'task' ))
		{
			case 'apply':
				$cid	= intval(JRequest::getVar('people_id'));
				$link =  'index.php?option=com_clubmanagement&view=member&task=edit&cid[]='. $cid ;
				$this->setRedirect($link, $msg);
			break;
			default:
				$link = 'index.php?option=com_clubmanagement&view=member';
				$this->setRedirect($link, $msg);
			break;
		}


	}

	/**
	 * cancel editing a record
	 * @return void
	 */
	function cancel()
	{
		$msg = JText::_( 'Operation Cancelled' );
		$this->setRedirect( 'index.php?option=com_clubmanagement&view=member', $msg );
	}

	/**
	 * remove record(s)
	 * @return void
	 */
	function remove()
	{
		$model = $this->getModel('member');
		if(!$model->delete()) {
			$msg = JText::_( 'Error: One or more Clubmanagements could not be Deleted' );
		} else {
			$msg = JText::_( 'Clubmanagement(s) Deleted' );
		}
		$this->setRedirect( 'index.php?option=com_clubmanagement&view=member', $msg );
	}
	
}
?>