<?php
class ClubmanagementHelper {
	public function createFamilyName($name, $surname) {
		return $surname.", ".$name;
	}
	
	/**
	*	@param $date String YYYY-MM-DD
	**/
	public function calcAgeInYears($date, $cmpDate = FALSE) {
		if ($cmpDate===FALSE) {
			$cmpDate = time();
		}

		$ckage = explode("-",$date); //das Datum wird mit explode anhand von "-" in ein Array zerlegt
		$ageyear = date("Y")-$ckage[0]; //Alter in Jahren ausrechnen
		$ckage = $ckage[1].$ckage[2]; //unsere Zahl aus dem Geburtstag
		$ckage2 = date("m", $cmpDate).date("d", $cmpDate); //unsere Zahl anhand des aktuellem Datum
		//wir vergleichen die 2 Zahlen und falls die Zahl aus dem Geburtstag größer als die Zahl des aktuellem Datums ist wird von dem Alter ein Jahr abgezogen
		if ( $ckage > $ckage2 ) {
			$ageyear--;
		} 
		return $ageyear;
		
	}

	private function orderObjectArray($a, $b) {
		return strcasecmp($a->contact, $b->contact);
	}

	public static function getCategories($extension) {
		return CategoryHelper::getFlat($extension);
	}

	public static function getSections() {
		return CategoryHelper::getFlat('Clubmanagement.sections');
	}

	public static function getLeagues() {
		return CategoryHelper::getFlat('Clubmanagement.leagues');
	}

	public function getPositions() {
		return CategoryHelper::getFlat('Clubmanagement.positions');
	}

	public function objarray2jsarray($array, $keys) {
		$a = array();
		for($i=0; $i<count($array); $i++) {
			$t = array();
			for($j=0; $j<count($keys); $j++) {
				$t[] = "'".$array[$i]->$keys[$j]."'";
			}
			$a[] = "[".implode(",", $t)."]";
		}
		return implode(",", $a);
	}
	/**
	 * Get the actions
	 */
	public static function getActions($messageId = 0)
	{	
		jimport('joomla.access.access');
		$user	= JFactory::getUser();
		$result	= new JObject;
 
		if (empty($messageId)) {
			$assetName = 'com_clubmanagement';
		}
		else {
			$assetName = 'com_clubmanagement.message.'.(int) $messageId;
		}
 
		$actions = JAccess::getActions('com_clubmanagement', 'component');

		foreach ($actions as $action) {
			$result->set($action->name,	$user->authorise($action->name, $assetName));
		}
 
		return $result;
	}


	public static function addSubmenu($vName)
	{
		if ($vName=='categories') {
			JToolBarHelper::title(JText::sprintf('COM_CATEGORIES_CATEGORIES_TITLE',JText::_('com_clubmanagement')),'banners-categories');
		}
		JSubMenuHelper::addEntry(JText::_('COM_CLUBMANAGEMENT_WELCOME_PAGE'), 'index.php?option=com_clubmanagement&view=welcome', $vName == 'welcome');
		JSubMenuHelper::addEntry(JText::_('COM_CLUBMANAGEMENT_ADMINISTER_CONTACTS'), 'index.php?option=com_clubmanagement&view=people', $vName == 'people');
		JSubMenuHelper::addEntry(JText::_('COM_CLUBMANAGEMENT_ADMINISTER_MEMBERSHIP'), 'index.php?option=com_clubmanagement&view=member', $vName == 'member');
		JSubMenuHelper::addEntry(JText::_('COM_CLUBMANAGEMENT_ADMINISTER_POSITIONS'), 'index.php?option=com_clubmanagement&view=positions', $vName == 'positions');
		JSubMenuHelper::addEntry(JText::_('COM_CLUBMANAGEMENT_ADMINISTER_TEAMS'), 'index.php?option=com_clubmanagement&view=teams', $vName == 'teams');
		JSubMenuHelper::addEntry(JText::_('COM_CLUBMANAGEMENT_ADMINISTER_PLAYER'), 'index.php?option=com_clubmanagement&view=player', $vName == 'player');
		JSubMenuHelper::addEntry(JText::_('COM_CLUBMANAGEMENT_ADMINISTER_TOURNAMENTS'), 'index.php?option=com_clubmanagement&view=tournaments', $vName == 'tournaments');
		JSubMenuHelper::addEntry(JText::_('COM_CLUBMANAGEMENT_ADMINISTER_SECTIONS'), 'index.php?option=com_categories&extension=com_clubmanagement.sections', $vName == 'categories');
		JSubMenuHelper::addEntry(JText::_('COM_CLUBMANAGEMENT_ADMINISTER_CONTACTTYPES'), 'index.php?option=com_categories&extension=com_clubmanagement.contacttypes', $vName == 'categories');
		JSubMenuHelper::addEntry(JText::_('COM_CLUBMANAGEMENT_ADMINISTER_POSITIONS'), 'index.php?option=com_categories&extension=com_clubmanagement.positions', $vName == 'categories');
		JSubMenuHelper::addEntry(JText::_('COM_CLUBMANAGEMENT_ADMINISTER_SEASONS'), 'index.php?option=com_categories&extension=com_clubmanagement.seasons', $vName == 'categories');
		JSubMenuHelper::addEntry(JText::_('COM_CLUBMANAGEMENT_ADMINISTER_LEAGUES'), 'index.php?option=com_categories&extension=com_clubmanagement.leagues', $vName == 'categories');
		JSubMenuHelper::addEntry(JText::_('COM_CLUBMANAGEMENT_ADMINISTER_TEAMMEMBERPOSITIONS'), 'index.php?option=com_categories&extension=com_clubmanagement.teammemberpositions', $vName == 'categories');
		JSubMenuHelper::addEntry(JText::_('COM_CLUBMANAGEMENT_MAINTENANCE'), 'index.php?option=com_clubmanagement&view=maintenance', $vName == 'maintenance');
	}
	
	/**
	*	assets table name column has varchar(50), this may be too short for clubmanagement.teammemberpositions.category.[id]
	*	extend column to varchar(100)
	*/
	public static function fixAssetTable() {
		$db		= JFactory::getDBO();
		$tname	= "#__assets";
		$fields = $db->getTableFields($tname, FALSE);
		if($fields[$tname]['name']->Type!='varchar(100)') {
			$query	= "ALTER TABLE ".$tname." CHANGE `name` `name` VARCHAR( 100 )";
			$db->setQuery($query);
			return $db->query();
		}
		return TRUE;
	}

}

?>