<?php
class LegendHelper {
	/**
	*	Contains Icons used during page building
	*/
	static $usedIcons = array();
	
	private static function loadIconByName($name, $value = NULL) {
		$object = new stdClass();
		$object->file = "";
		$object->desc = "";
		if (is_null($value)) {
			switch($name) {
				case "sex_m":
					$object->file = JPATH_ROOT.DS."administrator".DS."components".DS."com_clubmanagement".DS."assets".DS."icons".DS."male.png";
					$object->desc = JText::_("COM_CLUBMANAGEMENT_MALE");
				break;
				case "sex_f":
					$object->file = JPATH_ROOT.DS."administrator".DS."components".DS."com_clubmanagement".DS."assets".DS."icons".DS."female.png";
					$object->desc = JText::_("COM_CLUBMANAGEMENT_FEMALE");
				break;
				case "member_y":
					$object->file = JPATH_ROOT.DS."administrator".DS."components".DS."com_clubmanagement".DS."assets".DS."icons".DS."user-plain-green.png";
					$object->desc = JText::_("COM_CLUBMANAGEMENT_MEMBER");
				break;
				case "member_n":
					$object->file = JPATH_ROOT.DS."administrator".DS."components".DS."com_clubmanagement".DS."assets".DS."icons".DS."user-plain-red.png";
					$object->desc = JText::_("COM_CLUBMANAGEMENT_NOT_A_MEMBER");
				break;
				case "banking_fail":
					$object->file = JPATH_ROOT.DS."administrator".DS."components".DS."com_clubmanagement".DS."assets".DS."icons".DS."exclamation.png";
					$object->desc = JText::_("COM_CLUBMANAGEMENT_BANKING_ERROR");
				break;
				case "banking_empty":
					$object->file = JPATH_ROOT.DS."administrator".DS."components".DS."com_clubmanagement".DS."assets".DS."icons".DS."money_add.png";
					$object->desc = JText::_("COM_CLUBMANAGEMENT_BANKING_EMPTY");
				break;
				case "banking_ok":
					$object->file = JPATH_ROOT.DS."administrator".DS."components".DS."com_clubmanagement".DS."assets".DS."icons".DS."money_euro.png";
					$object->desc = JText::_("COM_CLUBMANAGEMENT_BANKING_OK");
				break;
				case "joomlauser":
					$object->file = JPATH_ROOT.DS."administrator".DS."components".DS."com_clubmanagement".DS."assets".DS."icons".DS."joomla_symbol_16.png";
					$object->desc = JText::_("COM_CLUBMANAGEMENT_JOOMLAUSER");
				break;
				case "clubmanager":
					$object->file = JPATH_ROOT.DS."administrator".DS."components".DS."com_clubmanagement".DS."assets".DS."icons".DS."group_key.png";
					$object->desc = JText::_("COM_CLUBMANAGEMENT_CLUBMANAGER");
				break;
				case "clubmanager_new":
					$object->file = JPATH_ROOT.DS."administrator".DS."components".DS."com_clubmanagement".DS."assets".DS."icons".DS."group_key_grey.png";
					$object->desc = JText::_("COM_CLUBMANAGEMENT_CLUBMANAGER");
				break;
				case "accept":
					$object->file = JPATH_ROOT.DS."administrator".DS."components".DS."com_clubmanagement".DS."assets".DS."icons".DS."accept.png";
					$object->desc = JText::_("COM_CLUBMANAGEMENT_ICON_ACCEPT");
				break;
				case "denied":
					$object->file = JPATH_ROOT.DS."administrator".DS."components".DS."com_clubmanagement".DS."assets".DS."icons".DS."cross.png";
					$object->desc = JText::_("COM_CLUBMANAGEMENT_ICON_DENIED");
				break;
				case "delete":
					$object->file = JPATH_ROOT.DS."administrator".DS."components".DS."com_clubmanagement".DS."assets".DS."icons".DS."delete.png";
					$object->desc = JText::_("COM_CLUBMANAGEMENT_DELETE");
				break;
				case "contact":
					$object->file = JPATH_ROOT.DS."administrator".DS."components".DS."com_clubmanagement".DS."assets".DS."icons".DS."email.png";
					$object->desc = JText::_("COM_CLUBMANAGEMENT_CONTACT");
				break;
				default:
#					if (is_object($name)) {
#						$object->file = JPATH_ROOT.DS."administrator".DS."components".DS."com_clubmanagement".DS."assets".DS."icons".DS.$name->name;
#						$object->desc = $name->desc;
#					} else {
#						return FALSE;
#					}
				break;
			}
		} else {
			switch($name) {
				case "flag":
					$params = JComponentHelper::getParams( 'com_clubmanagement' );
					if ($params->get( 'use_flagsoftheworld' ) && file_exists(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_flagsoftheworld'.DS.'helpers'.DS.'flagsoftheworld.php')) {
						require_once(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_flagsoftheworld'.DS.'helpers'.DS.'flagsoftheworld.php');
						$tmp = FlagsoftheworldHelper::getData("Micro-Flags-of-the-World", $value);
						$object->file = $tmp->file;
						$object->desc = $tmp->title;
#print_r($object);
					} else {
						$object->desc = $value;
					}
				break;
				case "manageitem":
					switch($value) {
						case "add":
							$object->file = JPATH_ROOT.DS."administrator".DS."components".DS."com_clubmanagement".DS."assets".DS."icons".DS."add.png";
							$object->desc = JText::_("COM_CLUBMANAGEMENT_ADD");
						break;
						case "edit":
							$object->file = JPATH_ROOT.DS."administrator".DS."components".DS."com_clubmanagement".DS."assets".DS."icons".DS."pencil.png";
							$object->desc = JText::_("COM_CLUBMANAGEMENT_EDIT");
						break;
						case "delete":
							$object->file = JPATH_ROOT.DS."administrator".DS."components".DS."com_clubmanagement".DS."assets".DS."icons".DS."delete.png";
							$object->desc = JText::_("COM_CLUBMANAGEMENT_DELETE");
						break;
					}
				break;
				case "reorder":
					switch($value) {
						case "up":
							$object->file = JPATH_ROOT.DS."administrator".DS."components".DS."com_clubmanagement".DS."assets".DS."icons".DS."uparrow.png";
							$object->desc = JText::_("COM_CLUBMANAGEMENT_ORDERUP");
						break;
						case "down":
							$object->file = JPATH_ROOT.DS."administrator".DS."components".DS."com_clubmanagement".DS."assets".DS."icons".DS."downarrow.png";
							$object->desc = JText::_("COM_CLUBMANAGEMENT_ORDERDOWN");
						break;
						case "cannotup":
							$object->file = JPATH_ROOT.DS."administrator".DS."components".DS."com_clubmanagement".DS."assets".DS."icons".DS."uparrow0.png";
							$object->desc = JText::_("COM_CLUBMANAGEMENT_ORDERCANNOTUP");
						break;
						case "cannotdown":
							$object->file = JPATH_ROOT.DS."administrator".DS."components".DS."com_clubmanagement".DS."assets".DS."icons".DS."delete.png";
							$object->desc = JText::_("COM_CLUBMANAGEMENT_ORDERCANNOTDOWN");
						break;
					}
				break;
				case "contact":
					switch($value) {
						case "emailhome":
						case "emailbusiness":
							$object->file = JPATH_ROOT.DS."administrator".DS."components".DS."com_clubmanagement".DS."assets".DS."icons".DS."delete.png";
							$object->desc = JText::_("COM_CLUBMANAGEMENT_ORDERUP");
						break;
						case "mobilehome":
						case "mobilebusiness":
							$object->file = JPATH_ROOT.DS."administrator".DS."components".DS."com_clubmanagement".DS."assets".DS."icons".DS."delete.png";
							$object->desc = JText::_("COM_CLUBMANAGEMENT_ORDERUP");
						break;
						case "phonehome":
						case "phonebusiness":
							$object->file = JPATH_ROOT.DS."administrator".DS."components".DS."com_clubmanagement".DS."assets".DS."icons".DS."telephone.png";
							$object->desc = JText::_("COM_CLUBMANAGEMENT_ORDERUP");
						break;
						default:
							$object->file = JPATH_ROOT.DS."administrator".DS."components".DS."com_clubmanagement".DS."assets".DS."icons".DS."information.png";
							$object->desc = JText::_("COM_CLUBMANAGEMENT_ORDERUP");
						break;
					}
				break;
				case "medal":
					switch($value) {
						case 1:
							$object->file = JPATH_ROOT.DS."administrator".DS."components".DS."com_clubmanagement".DS."assets".DS."icons".DS."medal_gold_1.png";
							$object->desc = JText::_("COM_CLUBMANAGEMENT_ICON_MEDAL_GOLD");
						break;
						case 2:
							$object->file = JPATH_ROOT.DS."administrator".DS."components".DS."com_clubmanagement".DS."assets".DS."icons".DS."medal_silver_1.png";
							$object->desc = JText::_("COM_CLUBMANAGEMENT_ICON_MEDAL_SILVER");
						break;
						case 3:
							$object->file = JPATH_ROOT.DS."administrator".DS."components".DS."com_clubmanagement".DS."assets".DS."icons".DS."medal_bronze_1.png";
							$object->desc = JText::_("COM_CLUBMANAGEMENT_ICON_MEDAL_BRONZE");
						break;
						default:
							//$object->file = JPATH_ROOT.DS."administrator".DS."components".DS."com_clubmanagement".DS."assets".DS."icons".DS."medal_gold_1.png";
							//$object->desc = JText::_("COM_CLUBMANAGEMENT_ICON_MEDAL_GOLD");
						break;
					}
				break;
			}
		}
		$object->icon = self::reformatFileAddress($object->file, "http");
		return $object;
	}
	
	public static function renderMultiIcon($general, $specific, $attr = NULL) {
		$obj = self::loadIconByName($general, $specific);
		if(is_array($attr)) {
			foreach($attr as $k => $v) {
				$obj->$k = $v;
			}
		}
		if (isset($obj->addToLegend) && $obj->addToLegend) {self::setLegendIcon($obj);}
		if (!empty($obj->icon)) {
			return self::renderIcon($obj);
		} else {
			return "<span class=\"flag icon ".strtolower($obj->desc)."\">".$obj->desc."</span>";
		}
	}

	public static function renderIcon($obj, $addToLegend = TRUE) {
		if (is_object($obj)) {
		} else if (is_array($obj)) {
			$obj = (object) $obj;
			$obj = self::loadIconByName($obj);
		} else {
			$obj = self::loadIconByName($obj);
		}
		if (!file_exists($obj->file) || !is_file($obj->file)) {
			return FALSE;
		}
		if ($addToLegend) {self::setLegendIcon($obj);}
		$class = (isset($obj->class)) ? " class=\"".$obj->class."\"" : "";
		return "<img src=\"".$obj->icon."\" alt=\"".$obj->desc."\" title=\"".$obj->desc."\"".$class."/>";
	}
	
	private static function reformatFileAddress($addr, $dest = "http") {
		switch($dest) {
			case "local":
				$addr = str_replace("/", DS, $addr);
				$addr = str_replace(JURI::root(), JPATH_ROOT.DS, $addr);
			break;
			default:
			case "http":
				if (file_exists($addr)) {
					$addr = str_replace(JPATH_ROOT.DS, JURI::root(), $addr);
					$addr = str_replace(DS, "/", $addr);
				} else {
					$addr = FALSE;
				}
			break;
		}
		return $addr;
	}
	
	public static function setLegendIcon($obj) {
		if (is_object($obj)) {
			if (file_exists($obj->file) && is_file($obj->file)) {
				$outputIMG = TRUE;
			} else {
				$outputIMG = FALSE;
			}
		} else {
			$obj = self::loadIconByName($obj);
		}
		array_push(self::$usedIcons, $obj);
	}
	
	public function printIconLegend() {
		$return = "";
		$bla2 = self::removeDuplicateLegendIcons();
		#usort($bla2, array ("LegendHelper", "cmp_obj"));
		foreach($bla2 as $obj) {
			if ($tmp = self::renderIcon($obj)) {
				$return .= "<li>".self::renderIcon($obj)."<span>".$obj->desc."</span></li>";
			} 
		}
		if (!empty($return)) {
			return "<ul class=\"legend\">".$return."</ul>";
		} else {
			return FALSE;
		}
	}

	private static function removeDuplicateLegendIcons() {
		$icons = self::$usedIcons;
		$r = array();
		for($i=0; $i<count($icons); $i++) {
			$r[$icons[$i]->icon] = $icons[$i];
		}
		return $r;
	}
	
	

    /* Dies ist die statische Vergleichsfunktion: */
    private function cmp_obj(&$a, &$b)
	{
		$al = strtolower($a->desc);
		$bl = strtolower($b->desc);
		if ($al == $bl) {
			return 0;
		}
		return ($al > $bl) ? +1 : -1;
	}
	
	public static function getAdminIcons($value) {
		#var_dump($value);
		switch(intval($value)) {
			case 0:
				$obj = self::loadIconByName('denied');
			break;
			case 1:
				$obj = self::loadIconByName('accept');
			break;
			case -1:
			break;
			default:
				return FALSE;
			break;
		}
		#print_r($obj);
		return self::renderIcon($obj);
	}
}

?>