<?php

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();
jimport('joomla.application.component.model');

class ClubmanagementModelBanking extends JModel
{
	/**
	 *
	 * @access	public
	 * @return	void
	 */
	function __construct()
	{
		parent::__construct();
		$array = JRequest::getVar('cid',  0, '', 'array');
		$this->setId((int)$array[0]);
	}


	/**
	 * Method to set the hello identifier
	 *
	 * @access	public
	 * @param	int Hello identifier
	 * @return	void
	 */
	function setId($id)
	{
		// Set id and wipe data
		$this->_id		= $id;
		$this->_data	= null;
	}
	
	public static function isValid($pid) {
		$db		= JFactory::getDBO();
		$query = "SELECT
			IF (p.bankaccountnumber='' && p.bankname = '' && p.bankcodenumber = '', 
			0, 
				IF(p.bankaccountnumber!='' && p.bankname != '' && p.bankcodenumber != '', 
				1, 
				-1)
			) AS bankaccount
			FROM #__clubmanagement_people AS p
			WHERE p.people_id = ".intval($pid);
		$db->setQuery($query);
#echo $db->getQuery();
		return $db->loadResult();
	}

	/**
	 * Method to get a hello
	 * @return object with data
	 */
	function &getData()
	{
		$db		= JFactory::getDBO();
		$query = "
			SELECT
				p.people_id,
				CONCAT(p.surname, ', ', p.name, ' (', DATE_FORMAT(p.birthday, '%d.%m.%Y'), ')') AS information,
				p.bankaccountnumber, 
				p.bankname, 
				p.bankcodenumber
			FROM #__clubmanagement_people AS p 
			WHERE p.people_id = '".$this->_id."'";
		$db->setQuery($query);
		$banking = $db->loadObject();
#echo "<p>".$db->getQuery()."</p>";
#print_r($banking);
		return $banking;
	}

	/**
	 * Method to store a record
	 *
	 * @access	public
	 * @return	boolean	True on success
	 */
	function store()
	{
		//$row = $this->getTable();
		$row = $this->getTable('people');
#echo "<h1>STORE</h1>";
#print_r($row);
		$data = JRequest::get( 'post' );
#print_r($data);
		// Bind the form fields to the hello table
		if (!$row->bind($data)) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}

		// Make sure the hello record is valid
		if (!$row->check()) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}
		// Store the web link table to the database
		$tmp = $row->store();
		if (!$tmp) {
			#$this->setError( $row->getErrorMsg() );
			$this->setError( $row->getErrorMsg() );
			return false;
		}
		ChangelogHelper::log(JFactory::getDBO()->getQuery(), $tmp);
		return true;
	}

	/**
	 * Method to delete record(s)
	 *
	 * @access	public
	 * @return	boolean	True on success
	 */
	function delete()
	{
	}
}
?>