<?php

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();
jimport('joomla.application.component.model');

class ClubmanagementModelTeammember extends JModel
{
	/**
	 * Constructor that retrieves the ID from the request
	 *
	 * @access	public
	 * @return	void
	 */
	function __construct()
	{
		parent::__construct();

		$tmp = JRequest::getVar('cid',  NULL);
		$this->setId((int)$tmp[0]);
$option = "com_clubmanagement.teammember.list";
		// Get pagination request variables
		$limit = JFactory::getApplication()->getUserStateFromRequest('global.list.limit', 'limit', JFactory::getApplication()->getCfg('list_limit'), 10);
		$limitstart = JFactory::getApplication()->getUserStateFromRequest($option.'.limitstart', 'limitstart', 0, 0);

		// In case limit has been changed, adjust it
		$limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);

		$this->setState('limit', $limit);
		$this->setState('limitstart', $limitstart);
		$this->getLists();

	}

	function &getLists() {
		$context= 'com_clubmanagement.teammember.list.';
		$filter	= null;

		$search				= JFactory::getApplication()->getUserStateFromRequest($context."search", 'search', '',	'string');
		$search				= JString::strtolower($search);

		$filter_order= JFactory::getApplication()->getUserStateFromRequest( $context.'filter_order', 'filter_order');
		if (!$filter_order) {
			//$filter_order = 'surname';
		}
		$filter_order_Dir= JFactory::getApplication()->getUserStateFromRequest($context.'filter_order_Dir', 'filter_order_Dir');
		$filter_state_member = JFactory::getApplication()->getUserStateFromRequest($context.'filter_state_member', 'filter_state_member', -1);
		$search = JFactory::getApplication()->getUserStateFromRequest($context.'search','search', '' );

		// table ordering
		$lists['order_Dir']	= $filter_order_Dir;
		$lists['order']		= $filter_order;

		// search filter
		$lists['search'] = $search;

		//	Filter
		$lists["filter_state_member"] = $filter_state_member;

		return $lists;
	}

	function setId($id)
	{
		// Set id and wipe data
		$this->_id		= $id;
		$this->_data	= null;
	}

	function getAllByTeam($team_id) {
		$db		= JFactory::getDBO();
		$lists = $this->getLists();
		$filter_order		= $lists["order"];
		$filter_order_Dir	= $lists["order_Dir"];
		$team_id = intval($team_id);
		$where = array();
		$where[] = "tm.team_id = ".intval($team_id);
		$order = "";

		$where = (count($where) ? ' WHERE '.implode(' AND ', $where) : '');


		$query = " 
			SELECT 
				tm.teammember_id, 
				tm.team_id, 
				tm.people_id, 
				tm.teammemberpositions_ordering, 
				tm.teammember_catid, 
				CONCAT(p.surname, ', ', p.name) AS name_complete, 
				c.title AS category

			FROM #__clubmanagement_teammember AS tm
			INNER JOIN #__clubmanagement_people AS p ON p.people_id = tm.people_id
			INNER JOIN #__categories AS c ON tm.teammember_catid = c.id
			".$where ."
			".$order."
			";

		$db->setQuery($query);
		//$this->setState('total', count($db->loadObjectlist()));
		//$db->setQuery($query, $this->getState('limitstart'), $this->getState('limit'));
//echo "<hr/>";
//echo str_replace("#__", "jos_", $db->getQuery());
//echo $query;
		return $db->loadObjectlist();
	}

	/**
	 * @return object with data
	 */
	function &getData()
	{
		$db		= JFactory::getDBO();
		$lists = $this->getLists();
		$filter_order		= $lists["order"];
		$filter_order_Dir	= $lists["order_Dir"];
		$search = $lists["search"];
		$where = array();

		switch(JRequest::getVar('task')) {
			case "add":
			break;
			case "edit":
				if(!is_null($this->_id)) {
					$where[] = "t.teammember_id = ".intval($this->_id);
					$this->setState('limitstart', NULL);
					$this->setState('limit', NULL);
				}
			break;
			default:
				if ($search) {
					//$where[] = 'LOWER( name_complete) LIKE '.$db->Quote( '%'.$db->getEscaped( $search, true ).'%', false );
				}
			break;
		}
		$where = (count($where) ? ' WHERE '.implode(' AND ', $where) : '');

		if (JRequest::getVar('task')=="add") {
			$p = new stdClass;
			$p->teammember_id			=	NULL;
			$p->team_id					=	"";
			$p->people_id				=	"";
			$p->position				=	"";
			$p->teammember_catid		=	"";

		} else {
			//$this->_data = array($p);
#		} elseif (JRequest::getVar('task')=="showall") {
			$order = ' ORDER BY '. $filter_order .' '. $filter_order_Dir .'';
//unset($this->_data);
			$order = "";
			//$where = "";
print_r($this->_data);
			if (empty( $this->_data)) {
				$query = " 
					SELECT 
						tm.team_id, 
						tm.name, 
						tm.description, 
						tm.season_identifier, 
						tm.league_catid, 
						p.name,
						c.title AS category

					FROM #__clubmanagement_teammember AS tm
					INNER JOIN #__people AS p ON p.people_id = t.people_id
					INNER JOIN #__categories AS c ON tm.league_catid = c.id
					".$where ."
					".$order."
					";

				$db->setQuery($query);
				$this->setState('total', count($db->loadObjectlist()));
				$db->setQuery($query, $this->getState('limitstart'), $this->getState('limit'));
				$this->_data = $db->loadObjectlist();
echo "<hr/>";
echo "<hr/>";
echo "<hr/>";
echo "<hr/>";
echo str_replace("#__", "jos_", $db->getQuery());
echo $query;
print_r($this->_data);
echo "<hr/>";
//var_dump($db->loadObjectlist('gna'));
			}
		}
		// Create the pagination object
		jimport('joomla.html.pagination');
		$this->_page = new JPagination($this->getState('total'), $this->getState('limitstart'), $this->getState('limit'));
		return $this->_data;
	}
	
	//public static function getSeasonIdentifier() {
	//	$db		= JFactory::getDBO();
	//	$where	= "";
	//	$order	= "";
	//	$query = " 
	//		SELECT 
	//			t.season_identifier AS value,
	//			t.season_identifier AS text
	//		FROM #__clubmanagement_teams AS t
	//		".$where ."
	//		".$order."
	//		GROUP BY t.season_identifier
	//		";

	//	$db->setQuery($query);
	//	return $db->loadObjectlist();
	//}

	/**
	 * Method to store a record
	 *
	 * @access	public
	 * @return	boolean	True on success
	 */
	function store($data = NULL)
	{
		$db		=& JFactory::getDBO();
		$row =& $this->getTable();
echo "<h1>STORE</h1>";
		if(is_null($data)) {
			$data = JRequest::get( 'post' );
		}
		// Bind the form fields to the hello table
		if (!$row->bind($data)) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}
		// Make sure the hello record is valid
		if (!$row->check()) {
			$this->setError($db	->getErrorMsg());
			return false;
		}
		// Store the web link table to the database
		//$tmp = $row->store(TRUE);
		$tmp = $row->store();
		if (!$tmp) {
			//$this->setError( $row->getErrorMsg() );
			return false;
		}
		ChangelogHelper::log($db->getQuery(), $tmp);
		return true;
	}

	/**
	 * Method to delete record(s)
	 *
	 * @access	public
	 * @return	boolean	True on success
	 */
	public function delete($cids = NULL)
	{
		if(is_null($cids)) {
			$cids = JRequest::getVar( 'cid', array(0), 'post', 'array' );
		}
		$row = $this->getTable();
		if (count( $cids ))
		{
			foreach($cids as $cid) {
				$tmp = $row->delete( $cid );
				if (!$tmp) {
					$this->setError( $row->getErrorMsg() );
					return false;
				} 
				ChangelogHelper::log(JFactory::getDBO()->getQuery(), $tmp);
			}						
		}
		return true;
	}

	public function deleteAllMemberByTeamId($tids) {
		$db		= JFactory::getDBO();
		$result = FALSE;
		if (is_array($tids) && count( $tids )>0)
		{
			JArrayHelper::toInteger($tids);
			$query = "DELETE FROM #__clubmanagement_teammember WHERE team_id IN (".implode(",", $tids).")";
			$db->setQuery($query);
			$result = $db->query();
			ChangelogHelper::log(JFactory::getDBO()->getQuery(), $result);
		}
		return $result;
	}


	function getPagination()
	{
		if (is_null($this->_list) || is_null($this->_page)) {
			$this->getLists();
		}
		return $this->_page;
	}
	
	public function getDataPreset() {
		$this->setId(NULL);
		$this->setState('limitstart', NULL);
		$this->setState('limit', NULL);
		$return = $this->getData();
		return $return;
	}
	
}
?>