<?php

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();
jimport('joomla.application.component.model');

class ClubmanagementModelTeams extends JModel
{
	/**
	 * Constructor that retrieves the ID from the request
	 *
	 * @access	public
	 * @return	void
	 */
	function __construct()
	{
		parent::__construct();

		$tmp = JRequest::getVar('cid',  NULL);
		$this->setId((int)$tmp[0]);
$option = "com_clubmanagement.teams.list";
		// Get pagination request variables
		$limit = JFactory::getApplication()->getUserStateFromRequest('global.list.limit', 'limit', JFactory::getApplication()->getCfg('list_limit'), 10);
		$limitstart = JFactory::getApplication()->getUserStateFromRequest($option.'.limitstart', 'limitstart', 0, 0);

		// In case limit has been changed, adjust it
		$limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);

		$this->setState('limit', $limit);
		$this->setState('limitstart', $limitstart);
		$this->getLists();

	}

	public function getLists() {
		$context= 'com_clubmanagement.teams.list.';
		$filter	= null;

		$search				= JFactory::getApplication()->getUserStateFromRequest($context."search", 'search', '',	'string');
		$search				= JString::strtolower($search);

		$filter_order= JFactory::getApplication()->getUserStateFromRequest( $context.'filter_order', 'filter_order');
		if (!$filter_order) {
			//$filter_order = 'surname';
		}
		$filter_order_Dir							= JFactory::getApplication()->getUserStateFromRequest($context.'filter_order_Dir', 'filter_order_Dir');
		//$filter_state_member = JFactory::getApplication()->getUserStateFromRequest($context.'filter_state_member', 'filter_state_member', -1);
		$filter_state_leagues 						= JFactory::getApplication()->getUserStateFromRequest($context.'filter_state_leagues', 'filter_state_leagues', 0);
		$filter_state_season_identifier 			= JFactory::getApplication()->getUserStateFromRequest($context.'filter_state_season_identifier', 'filter_state_season_identifier', 0);
		$filter_state_section_catid 				= JFactory::getApplication()->getUserStateFromRequest($context.'filter_state_section_catid', 'filter_state_section_catid', 0);

		$search = JFactory::getApplication()->getUserStateFromRequest($context.'search','search', '' );

		// table ordering
		$lists['filter_order_Dir']	= $filter_order_Dir;
		$lists['filter_order']		= $filter_order;

		// search filter
		$lists['search'] = $search;

		//	Filter
		//$lists["filter_state_member"] = $filter_state_member;
		$lists["filter_state_leagues"]				= $filter_state_leagues;
		$lists["filter_state_season_identifier"]	= $filter_state_season_identifier;
		$lists["filter_state_section_catid"]		= $filter_state_section_catid;

		return $lists;

	}

	function setId($id)
	{
		// Set id and wipe data
		$this->_id		= $id;
		$this->_data	= null;
	}

	public static function getSingle($tid) {
		$m = new self;
		$m->setId($tid);
		$m->setState('limit', 0);
		$m->setState('limitstart', 0);
		$tmp = $m->getData();
		if(is_array($tmp) && count($tmp)>0) {
			return $tmp[0];
		} else {
			return FALSE;
		}
	
	}
	
	public function getData()
	{
		$db		= JFactory::getDBO();
		$lists	= $this->getLists();
		$filter_order		= $lists["filter_order"];
		$filter_order_Dir	= $lists["filter_order_Dir"];
		$search = $lists["search"];
		$where = array();
		if(!is_null($this->_id) && $this->_id>0) {
//var_dump($this->_id);
			$where[] = "t.team_id = ".intval($this->_id);
			//$this->setState('limitstart', NULL);
			//$this->setState('limit', NULL);
		}
		switch(JRequest::getVar('task')) {
			case "add":
			break;
			case "edit":
				//if(!is_null($this->_id)) {
				//	$where[] = "t.team_id = ".intval($this->_id);
				//	$this->setState('limitstart', NULL);
				//	$this->setState('limit', NULL);
				//}
			break;
			default:
				if ($search) {
					//$where[] = 'LOWER( name_complete) LIKE '.$db->Quote( '%'.$db->getEscaped( $search, true ).'%', false );
				}
				if($lists['filter_state_leagues']) {
					$where[]	=	't.league_catid = '.intval($lists['filter_state_leagues']);
				}
				if($lists['filter_state_season_identifier']) {
					$where[]	=	't.season_identifier = "'.$lists['filter_state_season_identifier'].'"';
				}
				if($lists['filter_state_section_catid']) {
					$where[]	=	't.section_catid = "'.intval($lists['filter_state_section_catid']).'"';
				}
			break;
		}
		$where = (count($where) ? ' WHERE '.implode(' AND ', $where) : '');

		if (JRequest::getVar('task')=="add") {
			$p = new stdClass;
			$p->team_id				=	NULL;
			$p->name				=	"";
			$p->league_catid		=	"";
			$p->league				=	"";
			$p->season_identifier	=	"";
			$p->season_ordering		=	"";
			$p->description			=	"";
			$p->section_catid		=	NULL;

			$this->_data = array($p);
		} else {
#		} elseif (JRequest::getVar('task')=="showall") {
			$order = ' ORDER BY '. $filter_order .' '. $filter_order_Dir .'';
			$order = (!empty($filter_order) ? ' ORDER BY '. $filter_order .' '. (!empty($filter_order_Dir) ? $filter_order_Dir : 'ASC') : '');
//unset($this->_data);
			//$order = "";
			//$where = "";
			if (empty( $this->_data)) {
				$query = " 
					SELECT 
						t.team_id, 
						t.name, 
						t.description, 
						t.season_identifier, 
						t.season_ordering,
						(SELECT COUNT(*) FROM #__clubmanagement_teammember AS tm WHERE tm.team_id = t.team_id) AS teammembercount,
						t.league_catid, 
						t.league,
						l.title AS category,
						t.section_catid, 
						s.title AS section

					FROM #__clubmanagement_teams AS t
					LEFT JOIN #__categories AS l ON t.league_catid = l.id
					LEFT JOIN #__categories AS s ON t.section_catid = s.id
					".$where ."
					".$order."
					";

				$db->setQuery($query);
				$this->setState('total', count($db->loadObjectlist()));
				$db->setQuery($query, $this->getState('limitstart'), $this->getState('limit'));
				$this->_data = $db->loadObjectlist();
//echo "<hr/>";
//echo str_replace("#__", "jos_", $db->getQuery());
//echo $query;
//print_r($this->_data);
//echo "<hr/>";
//var_dump($db->loadObjectlist('gna'));
			}
		}
		// Create the pagination object
		jimport('joomla.html.pagination');
		$this->_page = new JPagination($this->getState('total'), $this->getState('limitstart'), $this->getState('limit'));
		return $this->_data;
	}
	
	public static function getBySeasonIdentifier($sid) {
		$db		= JFactory::getDBO();
		$query = " 
			SELECT 
				t.team_id, 
				t.name
			FROM #__clubmanagement_teams AS t
			WHERE t.season_identifier = '".$sid."'
			ORDER BY t.name ASC
			";
			$db->setQuery($query);
//echo str_replace("#__", "jos_", $db->getQuery());
			return $db->loadObjectlist();
	}
	
	public static function getSeasonIdentifier() {
		$db		= JFactory::getDBO();
		$where	= "";
		$order	= "";
		$query = " 
			SELECT 
				t.season_identifier AS value,
				t.season_identifier AS text
			FROM #__clubmanagement_teams AS t
			".$where ."
			".$order."
			GROUP BY t.season_identifier
			";

		$db->setQuery($query);
		return $db->loadObjectlist();
	}

	/**
	 * Method to store a record
	 *
	 * @access	public
	 * @return	boolean	True on success
	 */
	function store()
	{
		$db		= JFactory::getDBO();
		$row 	= $this->getTable();
		$data = JRequest::get( 'post' );
		$data['description']        = JRequest::getVar( 'description', '', 'post', 'string', JREQUEST_ALLOWRAW );

		// Bind the form fields to the hello table
		if (!$row->bind($data)) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}
		// Make sure the hello record is valid
		if (!$row->check()) {
			$this->setError($db	->getErrorMsg());
			return false;
		}
		// Store the web link table to the database
		$tmp = $row->store();
		if (!$tmp) {
			//$this->setError( $row->getErrorMsg() );
			return false;
		}
		ChangelogHelper::log($db->getQuery(), $tmp);
//print_r();
		//	delete previous teammember
		if(is_array($data['del_teammember_id']) && count($data['del_teammember_id'])>0) {
			$tmmodel = JModel::getInstance('ClubmanagementModelTeammember');
			foreach($data['del_teammember_id'] as $teammember_id => $delete) {
				if(!$delete || $delete=='false') {
					unset($data['del_teammember_id'][$teammember_id]);
				}
			}
				
			if(!$tmmodel->delete(array_keys($data['del_teammember_id']))) {

				$this->setError($this->_db->getErrorMsg());
				return false;
			}
		}
		
		//	add new teammember
		if(isset($data['new_teammember_people_id']) && is_array($data['new_teammember_people_id']) && count($data['new_teammember_people_id'])>0) {
			$tmmodel = JModel::getInstance('ClubmanagementModelTeammember');
			foreach($data['new_teammember_people_id'] as $k => $people_id) {
				$d = array();
				$d['team_id']						= $row->team_id;
				$d['people_id']						= $people_id;
				$d['teammemberpositions_ordering'] 	= $data['new_teammemberpositions_ordering'][$k];
				$d['teammember_catid']				= $data['new_teammemberposition_catid'][$k];

				if(!$tmmodel->store($d)) {
					$this->setError($this->_db->getErrorMsg());
					return false;
				}
			}
		}


		return true;
	}

	/**
	 * Method to delete record(s)
	 *
	 * @access	public
	 * @return	boolean	True on success
	 */
	function delete()
	{
		$cids = JRequest::getVar( 'cid', array(0), 'post', 'array' );
		$row =& $this->getTable();

		if (count( $cids ))
		{
			foreach($cids as $cid) {
				$tmp = $row->delete( $cid );
				if (!$tmp) {
					$this->setError( $row->getErrorMsg() );
					return false;
				} 
				ChangelogHelper::log(JFactory::getDBO()->getQuery(), $tmp);
			}						
			ClubmanagementModelTeammember::deleteAllMemberByTeamId($cids);
		}
		return true;
	}
	function getPagination()
	{
		if (is_null($this->_list) || is_null($this->_page)) {
			$this->getLists();
		}
		return $this->_page;
	}
	
	public function getDataPreset() {
		$this->setId(NULL);
		$this->setState('limitstart', NULL);
		$this->setState('limit', NULL);
		$return = $this->getData();
		return $return;
	}
	
}
?>