DROP TABLE IF EXISTS `#__clubmanagement_agegroups`;
CREATE TABLE IF NOT EXISTS `#__clubmanagement_agegroups` (
  `agegroup_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` text,
  `icon` varchar(50) DEFAULT NULL,
  `age_from` int(10) unsigned DEFAULT NULL,
  `age_until` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`agegroup_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1

DROP TABLE IF EXISTS `#__clubmanagement_changelog`;
CREATE TABLE IF NOT EXISTS `#__clubmanagement_changelog` (
  `query` text NOT NULL,
  `success` tinyint(1) DEFAULT NULL,
  `changed_by_joomlauser` int(11) DEFAULT NULL,
  `changed_by_username` varchar(20) NOT NULL,
  `changed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__clubmanagement_contacts`;
CREATE TABLE IF NOT EXISTS `#__clubmanagement_contacts` (
  `contacts_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `people_id` int(10) unsigned NOT NULL,
  `contacttype_id` int(10) unsigned NOT NULL,
  `contactpriority` int(1) unsigned NOT NULL,
  `contactdata` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`contacts_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1

DROP TABLE IF EXISTS `#__clubmanagement_memberaccount`;
CREATE TABLE IF NOT EXISTS `#__clubmanagement_memberaccount` (
  `transaction_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `people_id` int(10) unsigned NOT NULL,
  `date` date DEFAULT NULL,
  `transaction` decimal(5,2) DEFAULT NULL,
  `description` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`transaction_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1

DROP TABLE IF EXISTS `#__clubmanagement_membership`;
CREATE TABLE IF NOT EXISTS `#__clubmanagement_membership` (
  `membership_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `people_id` int(11) NOT NULL,
  `member_from` date DEFAULT NULL,
  `member_until` date DEFAULT NULL,
  `section_catid` int(10) unsigned NOT NULL,
  `passport` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`membership_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1

DROP TABLE IF EXISTS `#__clubmanagement_people`;
CREATE TABLE IF NOT EXISTS `#__clubmanagement_people` (
  `people_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sex` enum('m','f') DEFAULT 'm',
  `name` varchar(50) DEFAULT NULL,
  `surname` varchar(50) DEFAULT NULL,
  `birthday` date DEFAULT NULL,
  `address` varchar(100) DEFAULT NULL,
  `zipcode` varchar(10) DEFAULT NULL,
  `city` varchar(50) DEFAULT NULL,
  `country` varchar(3) DEFAULT NULL,
  `joomlauser` int(10) DEFAULT NULL,
  `bankaccountnumber` varchar(15) DEFAULT NULL,
  `bankname` varchar(50) DEFAULT NULL,
  `bankcodenumber` varchar(15) DEFAULT NULL,
  `passportPhotograph` varchar(100) DEFAULT NULL,
  `params` text NOT NULL,
  PRIMARY KEY (`people_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1

DROP TABLE IF EXISTS `#__clubmanagement_peoplepositions`;
CREATE TABLE IF NOT EXISTS `#__clubmanagement_peoplepositions` (
  `peoplepositions_id` int(11) NOT NULL AUTO_INCREMENT,
  `people_id` int(10) unsigned NOT NULL,
  `position_id` int(10) unsigned NOT NULL,
  `position_from` date DEFAULT NULL,
  `position_until` date DEFAULT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`peoplepositions_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1

DROP TABLE IF EXISTS `#__clubmanagement_teammember`;
CREATE TABLE IF NOT EXISTS `#__clubmanagement_teammember` (
  `teammember_id` int(11) NOT NULL AUTO_INCREMENT,
  `team_id` int(11) NOT NULL,
  `people_id` int(11) NOT NULL,
  `teammemberpositions_ordering` int(11) NOT NULL,
  `teammember_catid` int(11) NOT NULL,
  PRIMARY KEY (`teammember_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1

DROP TABLE IF EXISTS `#__clubmanagement_teams`;
CREATE TABLE IF NOT EXISTS `#__clubmanagement_teams` (
  `team_id` int(11) NOT NULL AUTO_INCREMENT,
  `season_ordering` int(2) NOT NULL,
  `name` varchar(50) NOT NULL,
  `description` text NOT NULL,
  `season_identifier` varchar(20) NOT NULL,
  `league_catid` int(11) NOT NULL,
  `league` varchar(50) NOT NULL,
  `section_catid` int(11) NOT NULL,
  PRIMARY KEY (`team_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1

DROP TABLE IF EXISTS `#__clubmanagement_tournamentpositions`;
CREATE TABLE IF NOT EXISTS `#__clubmanagement_tournamentpositions` (
  `tournamentposition_id` int(11) NOT NULL AUTO_INCREMENT,
  `tournament_id` int(11) NOT NULL,
  `people_id` int(11) NOT NULL,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`tournamentposition_id`),
  UNIQUE KEY `positions` (`tournament_id`,`people_id`,`position`),
  UNIQUE KEY `singleposition` (`tournament_id`,`people_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1
