<?php

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

jimport( 'joomla.application.component.view' );

/**
 * Hellos View
 *
 * @package    Joomla.Tutorials
 * @subpackage Components
 */
class ClubmanagementViewAdministration extends JView
{
	/**
	 * Hellos view display method
	 * @return void
	 **/
	function display($tpl = null)
	{
		// Get data from the model
		$model = $this->getModel('administration');
		$admins= & $model->getAll();
		$this->assignRef('admins', $admins);

		switch(JRequest::getVar("task")) {
			case "add":
				$tmp = $model->getNewUser();
				$this->assignRef('admin', $tmp);
				$this->assignRef('moreAdmins', AdministrationHelper::getJoomlaUserNotYetClubAdmins());

				JToolBarHelper::apply();
				JToolBarHelper::save();
				JToolBarHelper::cancel();
			break;
			case "edit":
				$cid = JRequest::getVar('cid', NULL);
				if (is_array($cid)) {
					$cid=$cid[0];
				}
				$this->assignRef('admin', $admins[$cid]);
				$this->assignRef('moreAdmins', AdministrationHelper::getJoomlaUserNotYetClubAdmins());

				JToolBarHelper::apply();
				JToolBarHelper::save();
				JToolBarHelper::cancel();
			break;
			default:
				JToolBarHelper::title(   JText::_( 'Clubmanagement Manager' ), 'generic.png' );
				if (count(AdministrationHelper::getJoomlaUserNotYetClubAdmins())>0) {
					JToolBarHelper::addNewX();
				}
				if (count($admins)>0) {
					JToolBarHelper::editListX();
				}
				JToolBarHelper::cancel();
				JToolBarHelper::deleteList();
			break;
		}

		$allParams		= & $model->getAllParams();
		$this->assignRef('allParams', $allParams);
		
		$editUser = JRequest::getVar('cid');
		if (is_array($editUser)) {$editUser = array_shift($editUser);}
		$this->assignRef('editUser', $editUser);
		parent::display($tpl);
	}
	
}
