<?php

// Check to ensure this file is included in Joomla!
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.plugin.plugin' );
jimport( 'joomla.filesystem.file' );

class plgContentClubmanagement extends JPlugin
{
	var $_debug;
	var $_library = array();
	var $_initialized = false;
	var $_instanceId = 0;
	
	function plgContentClubmanagement(& $subject, $config) {
		parent :: __construct($subject, $config);
		$this->_instanceId = rand(1000, 9999);
		
		$this->_debug = JRequest::getVar('debug_plg_clubmanagement') == true ? true : false;
    }
    
    function _PHP4() {
  		if (version_compare( phpversion(), '5.0' ) < 0) {
  			if (!$this->_initialized) {
  			  //Something is wrong with PHP4... let's repeat the work...	
  				$this->_instanceId = rand(1000, 9999);
  				$this->_initialize();
  			}
  			return true;
  		} else {
  		  return false;
  		}  		
    }
    
    function _initialize() {
        
		if ($this->_initialized) {
			JError::raiseWarning( '1' , 'plg_clubmanagements instanceId=' . $this->_instanceId . ' was initialized already');
			return true;
		}
		
    }
    
    /**
	 * Edit the content to render the link for the Clubmanagement
	 *
	 * @param 	object		The article object.  Note $article->text is also available
	 * @param 	object		The article params
	 * @param 	int			The 'page' number
	 * @return	string
	 */
	function onBeforeDisplayContent( &$article, &$params, $limitstart )
	{
		$this->_initialize();

		//simple performance check to determine whether bot should process further
	    if ( strpos( $article->text, '[clubmanagement' ) === false) {
			return '';
		}
		
		$menu = &JSite::getMenu();
		$cache = & JFactory :: getCache('plg_clubmanagement');

	    $this->_library = array(
			'[clubmanagement type="{type}" id="{id}"]{text}[/clubmanagement]'	=>	'{text}',
	    );

	    foreach ($this->_library  as $key => $val) {
	        $search         = array();
            $replace        = array();
	        
	        $key            = str_replace("[","\[",$key);
	        $key            = str_replace("]","\]",$key);
	        $tokens         = array();
	        $key_regexp = '%'.preg_replace('%\{([a-zA-Z0-9_]+)\}%', '(?P<$1>.*?)', $key).'%s';

	        preg_match_all($key_regexp, $article->text, $results);
	        if (!empty($results[0])) {

    	        $search = array_merge($search, $results[0]);
    	        foreach ($results as $k => $v) {
    	            if (!is_numeric($k)) {
    	                $tokens[] = $k;
    	            }
    	        }
    	        

                for($i=0;$i< count($results[0]);$i++) {
					$uri =& JURI::getInstance();
					switch($results['type'][$i]) {
						default:
						case "people":
							$query = array(
								'option'	=>	'com_clubmanagement',
								'view'		=>	'members',
								'layout'	=>	'personalfactsheet',
								'people_id'	=>	$results['id'][$i],
							);
						break;
					}
					$results['url'][$i] = JRoute::_("index.php?".http_build_query($query));
					$tokens[] 			= 'url';
	                $tmpval 			= $val;
	                foreach ($tokens as $token) {
	                    $tmpval = str_replace("{".$token."}", $results[$token][$i], $tmpval);
	                }
	                $replace[] = JHTML::link($results['url'][$i], $tmpval);
                }
	        }
	        $article->text = str_replace($search, $replace, $article->text);
	    }
		
		return '';
	}
	

}